% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Luminescence-generics.R
\name{remove_RLum}
\alias{remove_RLum}
\alias{remove_RLum,list-method}
\title{Strips records from RLum-class objects}
\usage{
remove_RLum(object, ...)

\S4method{remove_RLum}{list}(object, ...)
}
\arguments{
\item{object}{\linkS4class{RLum} (\strong{required}):  S4 object of class \code{RLum}}

\item{...}{further arguments passed to the specific class method}
}
\value{
Same as input, can be empty
}
\description{
Remove records from an RLum-class object in a convenient way using
\link{get_RLum} for the selection.
}
\section{Functions}{
\itemize{
\item \code{remove_RLum(list)}: Returns a list of \linkS4class{RLum} objects where the selected records are stripped

}}
\section{Function version}{
 0.1.0
}

\examples{
## load example data
data(ExampleData.XSYG, envir = environment())
sar <- OSL.SARMeasurement$Sequence.Object[1:9]

## strop only OSL curves
sar <- remove_RLum(sar, recordType = "OSL")
sar

}
\seealso{
\linkS4class{RLum.Analysis}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2025. remove_RLum(): Strips records from RLum-class objects. Function version 0.1.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.1.0. https://r-lum.github.io/Luminescence/
}

\keyword{utilities}
