




<!-- NEWS.md was auto-generated by NEWS.Rmd. Please DO NOT edit by hand!-->

# Changes in version 0.9.26 (2024-11-18)

## Removed functions

  - Function `calc_Kars2008()` (deprecated since version 0.8.1) is now
    officially defunct, `calc_Huntley2006()` should be used instead
    (\#252, fixed in \#257).

## Bugfixes

### `analyse_pIRIRSequence()`

  - The function crashed with a object merge error if run in a loop
    because of a `merge_RLum()` error. This was caused by a regression
    while implementing the `n_N` calculation in `plot_GrowthCurve()`.
    Potentially affected was also `analyse_SAR.CWOSL()`.
  - The function now shows a warning and sets `plot = FALSE` when option
    `plot.single = FALSE` is set but the device size is too small. This
    should prevent “Figure margins too large” errors.
  - The function will not crash anymore during the plotting in another
    edge case related to single grain data.

### `analyse_SAR.CWOSL()`

  - The function crashed for mixed set of `RLum.Analysis-class` objects
    typically observed for single grain data, e.g., one object contains
    only TL curves while all others contain the OSL/IRSL data from the
    grain. As the function filters those records automatically, it
    crashed because the aliquot number assignment internally relied on
    the length of the object (regression, \#373, fixed)

### `analyse_SAR.TL()`

  - The function now produces a more correct `rejection.criteria` data
    frame (\#245, fixed in \#246).
  - Several edge cases that led to crashes have been fixed (\#147, fixed
    in \#247).

### `get_RLum()`

  - When the function was used on a list of `RLum.Analysis-class`
    objects with the argument `null.rm = TRUE` it would remove all
    `NULL` objects, but not elements that became `list()` (empty list)
    during the selection; fixed.
  - Fix an edge case that caused a rather non-expected, more visible
    output problem. When curves were selected via `recordType` on
    `RLum.Analysis-class` objects (or a list of them) containing only a
    single `RLum.Data-class` object, the function returned the
    `RLum.Data.Curve-class` object *regardless* of the selection in
    `recordType`. In other words: if a user tried `recordType = "TL"` on
    an `RLum.Analysis-class` object that contained only a single IRSL
    curve, the function would still return that single IRSL curve
    instead of an empty element. The reason for this behaviour was a
    poor attempt to deal with `NA` in the `recordType` name that led to
    missing values and unexpected behaviour for a logical comparison.
    Now, before the subset happens, `NA` values in `recordType` are
    converted to `"NA"` (a character), allowing us to fix the incorrect
    subsetting.

### `plot_RLum.Data.Spectrum()`

  - Add support for `lphi` and `ltheta` light direction arguments for
    `plot.type = "persp"`.
  - Fix the reason for the unclear warning `In col.unique == col :
    longer object length is not a multiple of shorter object length`

### `write_R2BIN()`

  - Recently, non-ASCII characters in comments or file names have become
    more common and that led to crashes during the file export. To avoid
    this, now all non-ASCII characters are replaced by `_` before
    writing them to the BIN/BINX files.
  - The function now returns the file path of the export.
  - Fix a bug that left connections open if the function crashed.

## Internals

  - Two new internal functions `.throw_warning()` and `.throw_error()`
    sometimes flushed the terminal with messages if called (internally)
    in particular circumstances. Now we maintain a stack of function
    names, so that at any time we can report correctly the name of the
    function where an error or a warning is thrown (\#254, fixed in
    \#256).

# Changes in version 0.9.25 (2024-09-12)

**This package version requires R \>= 4.3**

## New functions

  - `read_HeliosOSL2R()`: New import function to support the new zero
    rad Helios luminescence reader and its `.osl` file format. The
    output is an `RLum.Analysis-class` object.

## Bugfixes

### `analyse_baSAR()`

  - Fix \#183 addressing an edge-case crash when the function was called
    on an object containing no records of the appropriate type (\#184,
    @mcol).

### `analyse_FadingMeasurements()`

  - Add `...` support to disable the blue trend line via `plot.trend =
    FALSE`
  - Fix \#175 to deal gracefully with the case when the size of Lx and
    Tx doesn’t match (\#192, @mcol).

### `analyse_portableOSL()`

  - Function did not respect argument `main`; fixed.

### `convert_Wavelength2Energy()`

  - Fix \#133 addressing cases where R throws an uncontained error when
    R drops the object structure in very rare cases (\#134; thanks
    @mcol)

### `calc_Huntley2006()`

  - Improve success rate of GOK fitting of the unfaded data using a two
    step approach: first an exponential fit is applied then this values
    are used as start parameters.

### `calc_Statistics()`

  - The skewness and kurtosis depended on number of MC samples (\#122);
    fixed with \#123 (thanks to @mcol)

### `calc_TLLxTxRatio()`

  - Function crashed for `Tx.data.background = NULL` (\#129); fixed with
    \#130 thanks to @mcol

### `calc_WodaFuchs2008()`

  - The function now officially supports numeric vectors and
    single-column data frames as input (\#200).
  - The function computed the number of breaks for the histogram
    incorrectly (\#197, fixed with \#198).
  - The function now supports more types of `RLum.Results` objects
    without crashing, although if the object contains only one data
    point it will stop immediately to avoid problems with `nls()`
    (\#199, fixed in \#219).

### `extract_IrradiationTimes()`

  - If a BIN/BINX-file is provided, the function will now check that it
    contains the same amount of data as the corresponding XSYG file a
    bit earlier than before, thus avoiding a possible crash (\#228,
    fixed in \#229).

### `fit_CWCurve()`

  - Argument `output.path` has been removed, and a warning is raised
    when attempting to use it (\#207, fixed in \#209).

### `fit_EmissionSpectra()`

  - Parameter `input_scale` was not correctly propagated when the
    function would self-call (\#160, @mcol).

### `fit_OSLLifeTimes()`

  - The validation of the minimum dataset size didn’t account for the
    use of the `signal.range` argument (\#182, fixed by \#195, @mcol).

### `fit_SurfaceExposure()`

  - Fix \#162 to remove a dimension mismatch if the input data contained
    `NA`s, which would generate unexpected warnings (\#163, @mcol).
  - The function doesn’t stop anymore with an error if called on an
    `RLum.Results` object (\#165, @mcol).

### `plot_AbanicoPlot()`

  - Argument `plot.ratio` will now throw an error on non-positive
    numerical values (\#221, fixed in \#222).
  - The function doesn’t crash anymore when setting `interactive = TRUE`
    (\#220, fixed in \#233).

### `plot_DetPlot()`

  - Argument `signal.integral.max` is now enforced to be greater than
    `signal.integral.min`, as otherwise the computation of the number of
    channels would produce `Inf` (\#203, fixed in \#206).
  - Fix a crash when using option `analyse_function =
    "analyse_pIRIRSequence"` (\#210, fixed in \#211).

### `plot_GrowthCurve()`

  - The function now calculates the relative saturation (`n/N`) using
    the ratio of the two integrates. The value is part of the output
    table.
  - Argument `na.rm` has been removed: as of version 0.9.23, it was
    defunct and only accepted `TRUE` as valid value and produced an
    error otherwise, so there is no effective change in behaviour
    (\#137, fixed in \#214).

### `plot_Histogram()`

  - The function doesn’t crash anymore when setting `interactive = TRUE`
    (\#186, fixed in \#231).

### `plot_KDE()`

  - It now officially supports numeric vectors and single-column data
    frames, for which it assumes that the De error at each measurement
    is 10^-9 (\#189, fixed in \#194, @mcol).

### `plot_NRt()`

  - The function reports an helpful message rather than crashing when
    applied to an object of unexpected type or when there is a mismatch
    in time values (\#177, fixed with \#179 by @mcol).

### `plot_RadialPlot()`

  - The function doesn’t crash anymore when a single-column data frame
    is provided (\#191, fixed in \#212).

### `plot_RLum.Data.Analysis()`

  - The function now supports all arguments from
    `plot_RLum.Data.Spectrum()`; before it had only basic functionality
    for `RLum.Data.Spectrum-class` data.

### `plot_RLum.Data.Spectrum()`

  - The plot function can now handle non-increasing column values for
    plotting (with a warning).

### `read_BIN2R()`

  - `ignore.RECTYPE` now supports numeric values, e.g., 128. Records for
    this type will be ignored during import.
  - BINX-files with `RECTYPE = 128` will not crash anymore, thanks for
    asking Anna-Maartje Boer and replying Karsten Bracht.
  - The function now stops graciously when attempting to read an empty
    file (\#225, fixed in \#226).

### `read_PSL2R()`

  - The function is out of the beta status, hence the flag was removed.
  - The `RLum.Analysis-class` object returned by the function gained a
    new element `Sequence`, which is a data frame. with the measured
    sequence. This way, if the original sequence was lost, it can still
    be extracted from the `.psl` data.
  - If no `.psl` file was found the function got trapped in an infinite
    loop (\#127); fixed with \#128 (thanks to @mcol)

### `read_XSYG2R()`

  - Fix spectrometer data import for basically broken files.

### `read_Daybreak2R()`

  - Fix \#135 to improve detection of non-ASCII files (\#140, @mcol).

### `Risoe.BINfileData2RLum.Analysis()`

  - Fix a crash when reading an empty Risoe.BINfileData input (\#215,
    fixed in \#224).

## Internals

  - New internal function + tests added `.get_named_list_element()`. It
    just does what the names says.
