% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ROI.R
\name{plot_ROI}
\alias{plot_ROI}
\title{Create Regions of Interest (ROI) Graphic}
\usage{
plot_ROI(
  object,
  exclude_ROI = c(1),
  dist_thre = -Inf,
  dim.CCD = NULL,
  bg_image = NULL,
  plot = TRUE,
  ...
)
}
\arguments{
\item{object}{\linkS4class{RLum.Analysis}, \linkS4class{RLum.Results} or a \link{list} of such objects (\strong{required}):
data input. Please note that to avoid function errors, only input created
by the functions \link{read_RF2R} or \link{extract_ROI} is accepted}

\item{exclude_ROI}{\link{numeric} (\emph{with default}): option to remove particular ROIs from the
analysis. Those ROIs are plotted but not coloured and not taken into account
in distance analysis. \code{NULL} excludes nothing.}

\item{dist_thre}{\link{numeric} (\emph{optional}): euclidean distance threshold in pixel
distance. All ROI for which the euclidean distance is smaller are marked. This
helps to identify ROIs that might be affected by signal cross-talk. Note:
the distance is calculated from the centre of an ROI, e.g., the threshold
should include consider the ROIs or grain radius.}

\item{dim.CCD}{\link{numeric} (\emph{optional}): metric x and y for the recorded (chip)
surface in µm. For instance \code{c(8192,8192)}, if set additional x and y-axes are shown}

\item{bg_image}{\linkS4class{RLum.Data.Image} (\emph{optional}): background image object
please note that the dimensions are not checked.}

\item{plot}{\link{logical} (\emph{with default}): enable or disable plot output to use
the function only to extract the ROI data}

\item{...}{further parameters to manipulate the plot. On top of all arguments of
\link[graphics:plot.default]{graphics::plot.default} the following arguments are supported: \code{lwd.ROI}, \code{lty.ROI},
\code{col.ROI}, \code{col.pixel}, \code{text.labels}, \code{text.offset}, \code{grid} (\code{TRUE/FALSE}), \code{legend} (\code{TRUE/FALSE}),
\code{legend.text}, \code{legend.pos}}
}
\value{
An ROI plot and an \linkS4class{RLum.Results} object with a matrix containing
the extracted ROI data and a object produced by \link[stats:dist]{stats::dist} containing
the euclidean distance between the ROIs.
}
\description{
Create ROI graphic with data extracted from the data imported
via \link{read_RF2R}. This function is used internally by \link{analyse_IRSAR.RF} but
might be of use to work with reduced data from spatially resolved measurements.
The plot dimensions mimic the original image dimensions
}
\section{Function version}{
 0.2.0
}

\examples{

## simple example
file <- system.file("extdata", "RF_file.rf", package = "Luminescence")
temp <- read_RF2R(file)
plot_ROI(temp)

## in combination with extract_ROI()
m <- matrix(runif(100,0,255), ncol = 10, nrow = 10)
roi <- matrix(c(2.,4,2,5,6,7,3,1,1), ncol = 3)
t <- extract_ROI(object = m, roi = roi)
plot_ROI(t, bg_image = m)

}
\seealso{
\link{read_RF2R}, \link{analyse_IRSAR.RF}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2024. plot_ROI(): Create Regions of Interest (ROI) Graphic. Function version 0.2.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., 2024. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.9.24. https://CRAN.R-project.org/package=Luminescence
}

\keyword{datagen}
\keyword{plot}
