% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RLum.Data.Image-class.R
\docType{class}
\name{RLum.Data.Image-class}
\alias{RLum.Data.Image-class}
\alias{show,RLum.Data.Image-method}
\alias{set_RLum,RLum.Data.Image-method}
\alias{get_RLum,RLum.Data.Image-method}
\alias{names_RLum,RLum.Data.Image-method}
\title{Class \code{"RLum.Data.Image"}}
\usage{
\S4method{show}{RLum.Data.Image}(object)

\S4method{set_RLum}{RLum.Data.Image}(class, originator, .uid, .pid,
  recordType = "Image", curveType = NA_character_,
  data = raster::brick(raster::raster(matrix())), info = list())

\S4method{get_RLum}{RLum.Data.Image}(object, info.object)

\S4method{names_RLum}{RLum.Data.Image}(object)
}
\arguments{
\item{object}{\code{\link{get_RLum}}, \code{\link{names_RLum}} (\strong{required}):
an object of class \linkS4class{RLum.Data.Image}}

\item{class}{\code{\link{set_RLum}}; \link{character}:
name of the \code{RLum} class to create}

\item{originator}{\code{\link{set_RLum}}; \link{character} (\emph{automatic}):
contains the name of the calling function (the function that produces this object);
can be set manually.}

\item{.uid}{\code{\link{set_RLum}}; \link{character} (\emph{automatic}):
sets an unique ID for this object using the internal C++ function \code{create_UID}.}

\item{.pid}{\code{\link{set_RLum}}; \link{character} (\emph{with default}):
option to provide a parent id for nesting at will.}

\item{recordType}{\code{\link{set_RLum}}; \link{character}:
record type (e.g. "OSL")}

\item{curveType}{\code{\link{set_RLum}}; \link{character}:
curve type (e.g. "predefined" or "measured")}

\item{data}{\code{\link{set_RLum}}; \link{matrix}:
raw curve data. If data is of type \code{RLum.Data.Image} this can be used to
re-construct the object.}

\item{info}{\code{\link{set_RLum}}; \link{list}:
info elements}

\item{info.object}{\code{\link{get_RLum}}; \link{character}:
name of the info object to returned}
}
\value{
\strong{\code{set_RLum}}

Returns an object from class \code{RLum.Data.Image}

\strong{\code{get_RLum}}
\enumerate{
\item Returns the data object (\link[raster:brick]{raster::brick})
\item only the info object if \code{info.object} was set.
}

\strong{\code{names_RLum}}

Returns the names of the info elements
}
\description{
Class for representing luminescence image data (TL/OSL/RF). Such data are for example produced
by the function \link{read_SPE2R}
}
\section{Methods (by generic)}{
\itemize{
\item \code{show}: Show structure of \code{RLum.Data.Image} object

\item \code{set_RLum}: Construction method for RLum.Data.Image object. The slot info is optional
and predefined as empty list by default..

\item \code{get_RLum}: Accessor method for RLum.Data.Image object. The argument info.object is
optional to directly access the info elements. If no info element name is
provided, the raw image data (RasterBrick) will be returned.

\item \code{names_RLum}: Returns the names info elements coming along with this curve object
}}

\section{Slots}{

\describe{
\item{\code{recordType}}{Object of class \link{character} containing the type of the curve (e.g. "OSL image", "TL image")}

\item{\code{curveType}}{Object of class \link{character} containing curve type, allowed values
are measured or predefined}

\item{\code{data}}{Object of class \link[raster:brick]{raster::brick} containing images (raster data).}

\item{\code{info}}{Object of class \link{list} containing further meta information objects}
}}

\note{
The class should only contain data for a set of images. For additional
elements the slot \code{info} can be used.
}
\section{Objects from the Class}{

Objects can be created by calls of the form \code{set_RLum("RLum.Data.Image", ...)}.
}

\section{Class version}{
 0.4.0
}

\examples{

showClass("RLum.Data.Image")

##create empty RLum.Data.Image object
set_RLum(class = "RLum.Data.Image")

}
\seealso{
\linkS4class{RLum}, \linkS4class{RLum.Data}, \link{plot_RLum}, \link{read_SPE2R}
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne (France)
} 

\section{How to cite}{
Kreutzer, S. (2018). RLum.Data.Image-class(): Class 'RLum.Data.Image'. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J. (2018). Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.8.2. https://CRAN.R-project.org/package=Luminescence
}

\keyword{classes}
\keyword{internal}
