% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/calc_HomogeneityTest.R
\name{calc_HomogeneityTest}
\alias{calc_HomogeneityTest}
\title{Apply a simple homogeneity test after Galbraith (2003)}
\usage{
calc_HomogeneityTest(data, log = TRUE, ...)
}
\arguments{
\item{data}{\code{\linkS4class{RLum.Results}} or \link{data.frame}
(\bold{required}): for \code{data.frame}: two columns with De
\code{(data[,1])} and De error \code{(values[,2])}}

\item{log}{\code{\link{logical}} (with default): peform the homogeniety test
with (un-)logged data}

\item{\dots}{further arguments (for internal compatibility only).}
}
\value{
Returns a terminal output. In addition an
\code{\linkS4class{RLum.Results}} object is returned containing the
following element:

\item{summary}{\link{data.frame} summary of all relevant model results.}
\item{data}{\link{data.frame} original input data} \item{args}{\link{list}
used arguments} \item{call}{\link{call} the function call}

The output should be accessed using the function
\code{\link{get_RLum}}
}
\description{
A simple homogeneity test for De estimates
}
\details{
For details see Galbraith (2003).
}
\section{Function version}{
 0.2 (2015-09-21 15:05:38)
}
\examples{
## load example data
data(ExampleData.DeValues, envir = environment())

## apply the homogeneity test
calc_HomogeneityTest(ExampleData.DeValues$BT998)
}
\author{
Christoph Burow, University of Cologne (Germany)
\cr R Luminescence Package Team}
\references{
Galbraith, R.F., 2003. A simple homogeneity test for estimates
of dose obtained using OSL. Ancient TL 21, 75-77.
}
\seealso{
\code{\link{pchisq}}
}

