% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/writeR2BIN.R
\name{writeR2BIN}
\alias{writeR2BIN}
\title{Export Risoe.BINfileData into Risoe BIN-file}
\usage{
writeR2BIN(object, file, version, compatibility.mode = FALSE,
  txtProgressBar = TRUE)
}
\arguments{
\item{object}{\code{\linkS4class{Risoe.BINfileData}} (\bold{required}):
input object to be stored in a bin file.}

\item{file}{\code{\link{character}} (\bold{required}): file name and path of
the output file\cr [WIN]: \code{writeR2BIN(object, "C:/Desktop/test.bin")},
\cr [MAC/LINUX]: \code{writeR2BIN("/User/test/Desktop/test.bin")}}

\item{version}{\code{\link{character}} (optional): version number for the
output file. If no value is provided the highest version number from the
\code{\linkS4class{Risoe.BINfileData}} is taken automatically.\cr\cr Note:
This argument can be used to convert BIN-file versions.}

\item{compatibility.mode}{\code{\link{logical}} (with default): this option
recalculates the position values if necessary and set the max. value to 48.
The old position number is appended as comment (e.g., 'OP: 70). This option
accounts for potential compatibility problems with the Analyst software.}

\item{txtProgressBar}{\link{logical} (with default): enables or disables
\code{\link{txtProgressBar}}.}
}
\value{
Write a binary file.
}
\description{
Exports a Risoe.BINfileData object in a *.bin or *.binx file that can be
opened by the Analyst software or other Risoe software.
}
\details{
The structure of the exported binary data follows the data structure
published in the Appendices of the Analyst manual p. 42.\cr\cr If
\code{LTYPE}, \code{DTYPE} and \code{LIGHTSOURCE} are not of type
\code{\link{character}}, no transformation into numeric values is done.
}
\note{
The function just roughly checks the data structures. The validity of
the output data depends on the user.\cr\cr The validity of the file path is
not further checked. \cr BIN-file conversions using the argument
\code{version} may be a lossy conversion, depending on the chosen input and
output data (e.g., conversion from version 07 to 06 to 04 or 03).\cr

\bold{Warning}\cr

Although the coding was done carefully it seems that the BIN/BINX-files
produced by Risoe DA 15/20 TL/OSL readers slightly differ on the byte level.
No obvious differences are observed in the METADATA, however, the
BIN/BINX-file may not fully compatible, at least not similar to the once
directly produced by the Risoe readers!\cr

Implementation of support for version 07 could so far not properly tested.
}
\section{Function version}{
 0.3.2 (2015-08-02 23:07:11)
}
\examples{
##uncomment for usage

##data(ExampleData.BINfileData, envir = environment())
##writeR2BIN(CWOSL.SAR.Data, file="[your path]/output.bin")
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne
(France)
\cr R Luminescence Package Team}
\references{
Duller, G., 2007. Analyst.
}
\seealso{
\code{\link{readBIN2R}}, \code{\linkS4class{Risoe.BINfileData}},
\code{\link{writeBin}}
}
\keyword{IO}

