% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lowWAFOMNX.R
\docType{package}
\name{LowWAFOMNX-package}
\alias{LowWAFOMNX-package}
\alias{LowWAFOMNX}
\title{Low WAFOM Niederreiter-Xing Sequence}
\description{
Description: R implementation of Low Walsh Figure of Merit Sequence
based on Niederreiter-Xing Sequence.
}
\details{
Porting to R by Mutsuo Saito.
The R version does not return coordinate value zero,
but returns value very near to zero, 2^-64.
}
\section{Acknowledgment}{

The development of this code is partially supported
by JST CREST.
}

\section{Reference}{

* Shinsuke Mori,
  "Suuchi Sekibun no tameno QMC Ten Shuugou no Sekkei, Tansaku,
  oyobi sono Yuukousei",
  Master's Thesis, 2017,
* Ryuichi Ohori,
  "Efficient Quasi Monte Carlo Integration by Adjusting the
  Derivation-sensitivity Parameter of Walsh Figure of Merit",
  Master's Thesis, 2015.
* S. Harase and R. Ohori,
  "A search for extensible low-WAFOM point sets",
  arXiv preprint, arXiv:1309.7828, (2013),
  https://arxiv.org/abs/1309.7828.
* Harase, S. (2016).
  "A search for extensible low-WAFOM point sets",
  Monte Carlo Methods and Applications, 22(4), pp. 349-357, 2017.
* M. Matsumoto and R. Ohori,
  "Walsh Figure of Merit for Digital Nets: An Easy Measure
  for Higher Order Convergent QMC",
  Springer International Publishing, Cham, 2016, pp. 143-160.
* M. Matsumoto, M. Saito, and K. Matoba,
  "A computable figure of merit for quasi-Monte Carlo point sets",
  Mathematics of Computation, 83 (2014), pp. 1233-1250.
* G. Pirsic,
  "A software implementation of Niederreiter-Xing sequences",
  in Monte Carlo and Quasi-Monte Carlo Methods 2000,
  Springer, 2002, pp. 434-445.
  https://sites.google.com/site/isabelpirsic/nxlegacy.
* C. P. Xing and H. Niederreiter,
  "A construction of low-discrepancy sequences using global
  function fields",
  ACTA ARITHMETICA, 73 (1995), pp. 87-102.
}

\examples{
srange <- lowWAFOMNX.dimMinMax()
mrange <- lowWAFOMNX.dimF2MinMax(srange[1])
points <- lowWAFOMNX.points(dimR=srange[1], dimF2=mrange[1])
points <- lowWAFOMNX.points(dimR=srange[1], dimF2=mrange[1], digitalShift=TRUE)
}
