% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LR-print-summary.R
\name{print.summary.LR}
\alias{print.summary.LR}
\alias{print.summary.LR_boot}
\title{Printing method for the summary of a Lorenz regression}
\usage{
\method{print}{summary.LR}(x, digits = max(3L, getOption("digits") - 3L), ...)

\method{print}{summary.LR_boot}(
  x,
  digits = max(3L, getOption("digits") - 3L),
  signif.stars = getOption("show.signif.stars"),
  ...
)
}
\arguments{
\item{x}{An object of class \code{"summary.LR"}. The object might also have S3 class \code{"summary.LR_boot"} (which inherits from class \code{"summary.LR"})}

\item{digits}{Number of significant digits to be passed.}

\item{...}{Additional arguments passed to the function \code{\link{print}}.}

\item{signif.stars}{Logical determining whether p-values should be also encoded visually. See the help of the function \code{\link{printCoefmat}} for more information.
This is only relevant if \code{x} inherits from \code{"summary.LR_boot"}.}
}
\value{
No return value, called for printing an object of class \code{"LR"} to the console.
}
\description{
Provides a printing method for an object of class \code{"summary.LR"}.
}
\examples{
## For examples see example(Lorenz.Reg) and example(Lorenz.boot)

}
\seealso{
\code{\link{summary.LR}}
}
