% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partition_X.R
\name{partition.X}
\alias{partition.X}
\title{Automated partitioning of estimated vector of long memory parameters into
       subvectors with equal memory.}
\usage{
partition.X(data, d.hat, m, m1, alpha = 0.05, report = FALSE)
}
\arguments{
\item{data}{(Txq) data matrix}

\item{d.hat}{(qx1) vector of d-estimates obtained using a local Whittle method such as
that described in Robinson (1995).}

\item{m}{the bandwidth parameter to be used for estimation of G}

\item{m1}{the bandwidth parameter used for estimation of d.vec with m1>>m}

\item{alpha}{the desired significance level for the tests}

\item{report}{either \code{TRUE} or \code{FALSE} determining, whether information
about the partitioning process should be printed to the user. Default is \code{report=FALSE}.}
}
\description{
\code{partition.X} conducts a sequence of tests for the equality of
             two or more estimated memory parameters to find possible partitions 
             of a vector into subvectors with equal memory parameters. 
             The procedure follows Robinson and Yajima (2002).
}
\details{
add a lot of details.
}
\examples{
library(fracdiff)
T<-1000
d1<-0.2
d2<-0.4
X<-cbind(fracdiff.sim(n=T,d=d1)$series,fracdiff.sim(n=T,d=d1)$series,
fracdiff.sim(n=T,d=d2)$series,fracdiff.sim(n=T,d=d2)$series)
alpha<-0.05
m1<-floor(1+T^0.75)
m<-floor(1+T^0.65)
d.hat<-c(local.W(X[,1],m=m1)$d,local.W(X[,2],m=m1)$d,local.W(X[,3],m=m1)$d,local.W(X[,4],m=m1)$d)
partition.X(data=X, d.hat=d.hat, m=m, m1=m1, alpha=0.05, report=TRUE)
}
\references{
Robinson, P. M. (1995): Gaussian semiparametric estimation of long rang
             dependence. The Annals of Statistics, Vol. 23, No. 5, pp. 1630-1661.
           
           Robinson, P. M. and Yajima, Y. (2002): Determination of cointegrating rank
           in fractional systems. Journal of Econometrics, Vol. 106, No.2, pp. 217-241.
}
\seealso{
\link{partitions}, \link{T.rho}, \link{T0stat}
}
