% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WWC15_LM.R
\name{FCI_WWC15}
\alias{FCI_WWC15}
\title{Semiparametric test for fractional cointegration (Wang, Wang, Chan (2015))}
\usage{
FCI_WWC15(X, m, mean_correct = c("init", "mean", "weighted", "none"),
  alpha = 0.05)
}
\arguments{
\item{X}{bivariate data matrix.}

\item{m}{bandwith parameter specifying the number of Fourier frequencies
used for the estimation, usually \code{floor(1+T^delta)}, where 0<delta<1.}

\item{mean_correct}{specifies the form of mean correction in the memory estimation.}

\item{alpha}{desired significance level. Default is \code{alpha=0.05}.}
}
\description{
\code{FCI_WWC15} Semiparametric implementation of the testing strategy for fractional cointegration by Wang, Wang, Chan (2015).
 Returns test statistic, critical value and testing decision. Null hypothesis: no fractional cointegration.
}
\examples{
T<-1000
series<-FI.sim(T=T, q=2, rho=0.4, d=c(0.1,0.8), B=rbind(c(1,1),c(0,1)))
FCI_WWC15(series,  m=floor(1+T^0.65))
series<-FI.sim(T=T, q=2, rho=0.4, d=c(0.8,0.8))
FCI_WWC15(series,  m=floor(1+T^0.65))
}
\references{
Wang, B., Wang, M. and Chan, N. H. (2015): Residual-based test for fractional cointegration. Economics Letters, Vol. 126, pp. 43 - 46.
 
Hualde, J. (2013): A simple test for the equality of integration orders. Economics Letters, Vol. 119, No. 3, pp. 233 - 237.
}
\author{
Christian Leschinski, Michelle Voges
}
