% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LncFinder.R
\name{find_orfs}
\alias{find_orfs}
\title{Find ORFs}
\usage{
find_orfs(OneSeq, reverse.strand = FALSE, max.only = TRUE)
}
\arguments{
\item{OneSeq}{Is one sequence. Can be a FASTA file read by package "seqinr"
\code{\link[seqinr]{seqinr-package}} or just a string.}

\item{reverse.strand}{Logical. Whether find ORF on the reverse strand. Default: \code{FALSE}}

\item{max.only}{Logical. If \code{TRUE}, only the longest ORF will be returned.  Default: \code{TRUE}}
}
\value{
If \code{max.only = TRUE}, the function returns a list which consists the ORF region (\code{ORF.Max.Seq}),
length (\code{ORF.Max.Len}) and coverage (\code{ORF.Max.Cov}) of the longest ORF.
If \code{max.only = FALSE}, the function returns a dataframe which consists all the ORF sequences.
}
\description{
This function can find all the ORFs in one sequence.
}
\details{
This function can extract ORFs of one sequence. It returns
ORF region, length and coverage of the longest ORF when \code{max.only = TRUE} or
ORF region, start position, end position, length and coverage of all the ORFs when
\code{max.only = FALSE}. Coverage is the the ratio
of the ORF to transcript length. If \code{reverse.strand = TRUE}, ORF will also be
found on reverse strand.
}
\examples{
### For one sequence:
OneSeq <- c("cccatgcccagctagtaagcttagcc")
orf.info_1 <- find_orfs(OneSeq, reverse.strand = TRUE, max.only = FALSE)

### For a FASTA file contains several sequences:
\dontrun{
### Use "read.fasta" function of package "seqinr" to read a FASTA file:
Seqs <- seqinr::read.fasta(file =
"http://www.ncbi.nlm.nih.gov/WebSub/html/help/sample_files/nucleotide-sample.txt")
}

### Or just try to use our data "demo_DNA.seq"
data(demo_DNA.seq)
Seqs <- demo_DNA.seq

### Use apply function to find the longest ORF:
orf.info_2 <- sapply(Seqs, find_orfs, reverse.strand = FALSE, max.only = FALSE)
}
\author{
HAN Siyu
}
