% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateArcAngles.R
\name{CreateArcAngles}
\alias{CreateArcAngles}
\title{Creates an arc of a circumference}
\usage{
CreateArcAngles(C, r, angle1, angle2)
}
\arguments{
\item{C}{Vector containing the xy-coordinates of the center of the circumference}

\item{r}{Radius for the circumference (or arc)}

\item{angle1}{- Angle in degrees (0-360) at which the arc starts}

\item{angle2}{- Angle in degrees (0-360) at which the arc finishes}
}
\value{
Returns a vector which contains the center, radius and angles (0-360) that define the created arc
}
\description{
\code{CreateArcAngles} creates an arc of a circumference
}
\examples{
x_min <- -5
x_max <- 5
y_min <- -5
y_max <- 5
CoordinatePlane(x_min, x_max, y_min, y_max)
C <- c(0,0)
r <- 3
angle1 <- 90
angle2 <- 180
Arc <- CreateArcAngles(C, r, angle1, angle2)
Draw(Arc, "black")
}
