% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_setup.R
\docType{methods}
\name{LeMansParam}
\alias{LeMansParam}
\alias{LeMansParam,ANY,ANY-method}
\alias{LeMansParam,missing,ANY-method}
\alias{LeMansParam,missing,missing-method}
\title{A constructor for the \code{LeMansParam} class}
\usage{
LeMansParam(df, gdf, ...)

\S4method{LeMansParam}{ANY,ANY}(df, gdf, nfish = nrow(df), nsc = 32,
  pred_mu = -2.25, pred_sigma = 0.5, other = 1e+12, bounds = NULL,
  calc_phi_min = FALSE, phi_min = 0.1, vary_growth = TRUE,
  growth_eff = 0.5, growth_eff_decay = 0.11, eps = 1e-05,
  force_mature = TRUE, species_names = paste("species", 1:nfish, sep =
  "_"), kappa = rep(10, nfish), tau = matrix(1, nfish, nfish),
  rec_fun = rep("hockey-stick", nfish), recruit_params = list(a =
  18.835 - 4.133 * df$Linf, b = rep(1000/nfish, nfish)),
  natmort_opt = rep("std_RNM", nfish), Nmort = rep(0.8, nfish),
  prop = rep(3/4, nfish), curve = rep("logistic", nfish),
  catch_species = ((0:(length(curve) - 1))\%\%nfish) + 1,
  max_catchability = rep(1, length(curve)), gear_name = paste("gear_",
  1:length(curve), sep = ""), custom = NULL, ...)

\S4method{LeMansParam}{missing,ANY}(gdf, nfish = length(Linf),
  nsc = 32, pred_mu = -2.25, pred_sigma = 0.5, other = 1e+12,
  bounds = NULL, calc_phi_min = FALSE, phi_min = 0.1,
  vary_growth = FALSE, growth_eff = 0.5, growth_eff_decay = 0.11,
  eps = 1e-05, force_mature = TRUE, Linf, k, W_a, W_b, Lmat,
  species_names = paste("species", 1:nfish, sep = "_"), kappa = rep(10,
  nfish), tau = matrix(1, nfish, nfish), rec_fun = rep("hockey-stick",
  nfish), recruit_params = list(a = 18.835 - 4.133 * Linf, b =
  rep(1000/nfish, nfish)), natmort_opt = rep("std_RNM", nfish),
  Nmort = rep(0.8, nfish), prop = rep(3/4, nfish),
  curve = rep("logistic", nfish), catch_species = ((0:(length(curve) -
  1))\%\%nfish) + 1, max_catchability = rep(1, length(curve)),
  gear_name = paste("gear_", 1:length(curve), sep = ""), custom = NULL,
  ...)

\S4method{LeMansParam}{missing,missing}(df, gdf, nfish = length(Linf),
  nsc = 32, pred_mu = -2.25, pred_sigma = 0.5, other = 1e+12,
  bounds = NULL, calc_phi_min = TRUE, phi_min = 0.1,
  vary_growth = FALSE, growth_eff = 0.5, growth_eff_decay = 0.11,
  eps = 1e-05, force_mature = TRUE, species_names = paste("species",
  1:nfish, sep = "_"), Linf, k, W_a, W_b, Lmat, kappa = rep(10, nfish),
  tau = matrix(1, nfish, nfish), rec_fun = rep("hockey-stick", nfish),
  recruit_params = list(a = 18.835 - 4.133 * Linf, b = rep(1000/nfish,
  nfish)), natmort_opt = rep("std_RNM", nfish), Nmort = rep(0.8,
  nfish), prop = rep(3/4, nfish), curve = rep("logistic", nfish),
  catch_species = ((0:(length(curve) - 1))\%\%nfish) + 1,
  max_catchability = rep(1, length(curve)), gear_name = paste("gear_",
  1:length(curve), sep = ""), custom = NULL, ...)
}
\arguments{
\item{df}{A data frame with \code{nfish} rows and the following columns: \code{Linf}, \code{W_a}, \code{W_b}, \code{k} and \code{Lmat}. See below for definitions of each of these parameters.}

\item{gdf}{A data frame with \code{nfish} rows and the following columns: \code{curve}, \code{catch_species}, \code{max_catchability}, \code{k} and \code{gear_name}. See below for definitions of each of these parameters.}

\item{...}{Additional arguments for calculating catchability curves. See \code{\link{calc_Q}} for more details.}

\item{nfish}{A numeric value representing the number of fish species in the model.}

\item{nsc}{A numeric value representing the number of length classes in the model.}

\item{pred_mu}{A numeric value representing the preferred predator-prey mass ratio.}

\item{pred_sigma}{A numeric value representing the width of the weight preference function.}

\item{other}{A numeric value representing the amount of other food (g) available from prey that is not explicitly represented in the model. The default is \code{1e12}.}

\item{bounds}{An optional argument specifying the bounds of the length classes.}

\item{calc_phi_min}{A logical statement indicating whether \code{phi_min} should be calculated within the function. The default is \code{FALSE}.}

\item{phi_min}{A fixed numeric value of \code{phi_min}, which represents the time step of the model. This parameter is only required if \code{calc_phi_min=FALSE}. The default is \code{0.1}.}

\item{vary_growth}{A logical statement indicating whether growth efficiency should vary for each species (\code{vary_growth=TRUE}) or be fixed at the value given by \code{fixed_growth} (\code{vary_growth=FALSE}). The default is \code{TRUE}.}

\item{growth_eff}{If \code{vary_growth==TRUE}, \code{growth_eff} is a numeric representing the growth efficiencies of a fish of length 0. If \code{vary_growth==FALSE}, \code{growth_eff} is a numeric value of length \code{1} representing a fixed growth efficiency for all fish. The default is 0.5.}

\item{growth_eff_decay}{A numeric value specifying the rate at which growth efficiency decreases as length increases to \code{Linf}. The default is 0.11.}

\item{eps}{A numeric value specifying a numerical offset. The default value is \code{1e-5}.}

\item{force_mature}{A logical statement indicating whether to force maturity for all fish in the largest length class. The default is \code{TRUE}.}

\item{species_names}{A numeric or character vector of length \code{nfish} that denotes the names of the species in the model.}

\item{kappa}{A numeric vector of length \code{nfish} representing the rate of change from immature to mature fish.}

\item{tau}{A matrix with dimensions \code{nfish} and \code{nsc}. Row indices represent predators and column indices represent prey. A value of 1 at location \code{i}, \code{j} indicates prey \code{j} is eaten by predator \code{i}.}

\item{rec_fun}{A character vector representing the stock recruitment function to be applied to each species. The default value is \code{"hockey-stick"} but \code{rec_fun} can take a value of \code{"Ricker"}, \code{"Beverton-Holt"}, \code{"constant"}, or \code{"linear"} for each species.}

\item{recruit_params}{A list object of length \code{nfish} specifying the parameters for the recruitment function.}

\item{natmort_opt}{A character vector of length \code{1} describing the mortality function to be used for the species. The default value is \code{"std_RNM"} but can take a value of \code{"constant"} or \code{"linear"}. See \code{calc_M1} for more information.}

\item{Nmort}{A numeric vector of length \code{nfish} representing the maximum background mortality of each species. The default is \code{0.8} for all species.}

\item{prop}{A numeric vector of length \code{nfish} representing the proportion of length classes that have a non-zero background mortality. This is required only when the \code{natmort_opt} mortality function is used. The default is \code{3/4}.}

\item{curve}{A character vector of almost any length describing the type of curve to be used to determine the catchability of each species by fishing gear. By default, \code{curve} is a character vector of length \code{nfish} that takes the value \code{"logistic"} in each element, but it can also take a value of \code{"log-gaussian"} or \code{"knife-edge"}. If a custom curve is required for a particular species and/or fishing gear, the curve must be specified in \code{custom}.}

\item{catch_species}{A numeric value or character string describing the species to apply the catchability curve to.}

\item{max_catchability}{A numeric vector of length \code{curve} describing the maximum catchability for each catchability curve.}

\item{gear_name}{A character vector of the same length as \code{curve} and \code{species} describing the fishing gear that each element of \code{curve} and \code{species} relates to. By default, \code{gear_name} is a character vector of length \code{curve} that takes the value \code{paste("gear_", 1:length(curve), sep = "")}.}

\item{custom}{An array with dimensions \code{nsc}, \code{nfish} and the number of custom catchability curves that are required. \code{custom} represents the catchability of each species by the gears specified using custom catchability curves. By default, \code{custom} is set to \code{NULL}.}

\item{Linf}{A numeric vector of length \code{nfish} representing the mid-point of the length classes.}

\item{k}{k A numeric vector of length \code{nfish} representing the von Bertalanffy growth parameter \code{(1/yr)} for each species.}

\item{W_a}{A numeric vector representing the parameter \code{a} in the length-weight conversion.}

\item{W_b}{A numeric vector representing the parameter \code{b} in the length-weight conversion.}

\item{Lmat}{A numeric vector of length \code{nsc} representing the length at which 50\% of the individuals are mature.}
}
\value{
An object of class \code{LeMansParam} for use in the LeMans model.
}
\description{
A constructor for the \code{\link{LeMansParam}} class.
}
\details{
Converts objects of class data frame or vector to class LeMansParams for use in the LeMans model. \code{Linf}, \code{W_a}, \code{W_b}, \code{k} and \code{Lmat} are required as either a data frame or as vectors.
}
\examples{
# To run the model with all inputs specified explicitly:
# Set up species-specific parameters
Linf <- NS_par$Linf # the von-Bertalanffy asymptotic length of each species (cm).
W_a <- NS_par$W_a # length-weight conversion parameter.
W_b <- NS_par$W_b # length-weight conversion parameter.
k <- NS_par$k # the von-Bertalnaffy growth parameter.
Lmat <- NS_par$Lmat # the length at which 50\% of individuals are mature (cm).

NS_params <- LeMansParam(species_names=NS_par$species_names, Linf=Linf, k=k, W_a=W_a, W_b=W_b,
Lmat=Lmat, tau=NS_tau, recruit_params=list(a=NS_par$a, b=NS_par$b), eta=rep(0.25, 21), L50=Lmat,
other=NS_other)

###############################################
# Alternatively:
NS_params <- LeMansParam(NS_par, tau=NS_tau, eta=rep(0.25, 21), L50=NS_par$Lmat, other=NS_other)
}
\seealso{
\code{\link{run_LeMans}}, \code{\linkS4class{LeMans_param}}
}
