% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{summaryBMA}
\alias{summaryBMA}
\title{Summary Tables for \code{ULLGM_BMA} Estimation Results}
\usage{
summaryBMA(x,
           variable_names = NULL,
           digits         = 3,
           sort           = FALSE,
           type           = "pandoc")
}
\arguments{
\item{x}{The output object of \code{ULLGM_BMA}.}

\item{variable_names}{A character vector specifying the names of the columns of X.}

\item{digits}{Number of digits to round the table to. Defaults to 3.}

\item{sort}{Logical, indicating whether the table should be sorted by PIPs. Default is \code{FALSE}.}

\item{type}{A character string indicating the format of the table. Options are \code{'pandoc'} (default), \code{'latex'}, or \code{'html'}.}
}
\value{
Returns a 'knitr::kable' object containing the summary table.
}
\description{
\code{summaryBMA} produces a table with estimated posterior means, standard deviations, and posterior inclusion probabilities (PIPs) for the results of a \code{ULLGM_BMA} estimation.
}
\examples{
# Load package
library(LatentBMA)

# Example: Estimate a PLN model under a BRIC prior with m = p/2 using simulated data
# Note: Use more samples for actual analysis
# Note: nsave = 250 and nburn = 250 are for demonstration purposes
X <- matrix(rnorm(100*20), 100, 20)
z <- 2 + X \%*\% c(0.5, -0.5, rep(0, 18)) + rnorm(100, 0, sqrt(0.25))
y <- rpois(100, exp(z))
results_pln <- ULLGM_BMA(X = X, y = y, model = "PLN", nsave = 250, nburn = 250)
summaryBMA(results_pln)

}
\author{
Gregor Zens
}
