% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/periodogram.R
\name{periodogram}
\alias{periodogram}
\title{Periodogram function}
\usage{
periodogram(y, plot = TRUE, include.taper = FALSE)
}
\arguments{
\item{y}{(type: numeric) data vector}

\item{plot}{(type: logical) logical argument which allows to plot the
periodogram. Defaults to TRUE.}

\item{include.taper}{(type: logical) logical argument which by default is
\code{FALSE}. If \code{include.taper=TRUE} then \code{y} is multiplied by
\eqn{0.5(1 - \cos(2\pi(n-1)/n))} (cosine bell).}
}
\value{
A list with with the periodogram and the lambda values.
}
\description{
This function computes the periodogram from a stationary time
serie. Returns the periodogram, its graph and the Fourier frequency.
}
\details{
The tapered periodogram it is given by
\deqn{I(\lambda) = \frac{|D_n(\lambda)|^2}{2\pi
H_{2,n}(0)}} with \eqn{D(\lambda) = \sum_{s=0}^{n-1} h
\left(\frac{s}{N}\right) y_{s+1}\,
e^{-i\,\lambda\,s}}, \eqn{H_{k,n} = \sum_{s=0}^{n-1}h
\left(\frac{s}{N}\right)^k\,
e^{-i\,\lambda\,s}} and \eqn{\lambda} are Fourier frequencies defined as
\eqn{2\pi k/n}, with \eqn{k = 1,\,\ldots,\, n}.
The data taper used is the cosine bell function,
\eqn{h(x) = \frac{1}{2}[1-\cos(2\pi x)]}. If the series has missing data,
these are replaced by the average of the data and \eqn{n} it is corrected by
$n-N$, where \eqn{N} is the amount of missing values of serie. The plot of
the periodogram is \code{periodogram} values vs. \eqn{\lambda}.
}
\examples{
# AR(1) simulated
set.seed(1776)
ts.sim <- arima.sim(n = 1000, model = list(order = c(1, 0, 0), ar = 0.7))
per <- periodogram(ts.sim)
per$plot
}
\references{
For more information on theoretical foundations and estimation methods see
\insertRef{brockwell2002introduction}{LSTS}
\insertRef{dahlhaus1997fitting}{LSTS}
}
\seealso{
\code{\link[stats]{fft}}, \code{\link[base]{Mod}},
\code{\link[stats]{smooth.spline}}.
}
