% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PartialDependenceplot.R
\name{PartialDependencePlot}
\alias{PartialDependencePlot}
\title{Partial Dependence Plot}
\usage{
PartialDependencePlot(
  data = NULL,
  FeatureNames = NULL,
  FittedModelObject = NULL,
  j = 20
)
}
\arguments{
\item{data}{A \code{data.frame} that contains the study’s features and the outcome.}

\item{FeatureNames}{A vector with the names of features to plot.}

\item{FittedModelObject}{A fitted model object.}

\item{j}{A numerical value that indicates the size of the equally spaced values for the feature of interest.}
}
\value{
This function returns a plot where X axis presents the values for each feature and Y axis illustrates the predicted proportion of correct answer to the item.
}
\description{
Partial Dependence Plot
}
\examples{
\donttest{
colnames(training)[14] <- "perf"
ensemblist <- TreeModels(traindata = training,
methodlist = c("dt","rf"),checkprogress = TRUE)

PartialDependencePlot(data = training,
FeatureNames = colnames(training[-c(4,14)]),
FittedModelObject = ensemblist$ModelObject$rpart, j = 30)

PartialDependencePlot(data = training,
FeatureNames = colnames(training[-c(4,14)]),
FittedModelObject = ensemblist$ModelObject$ranger, j = 20)
}
}
