% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rLnormParMix.R
\name{rLnormParMix}
\alias{rLnormParMix}
\title{Random number simulation for a mixture of a lognormal and a Pareto r.v.}
\usage{
rLnormParMix(n, pi, mu, sigma, xmin, alpha)
}
\arguments{
\item{n}{positive integer: number of simulated random numbers.}

\item{pi}{scalar, 0 < pi < 1: mixing weight.}

\item{mu}{scalar: expected value of the lognormal distribution on the log scale.}

\item{sigma}{positive scalar: standard deviation of the lognormal distribution on the log scale.}

\item{xmin}{positive scalar: threshold.}

\item{alpha}{non-negative scalar: Pareto shape parameter.}
}
\value{
n iid random numbers from the lognormal-Pareto distribution.
}
\description{
This function simulates random numbers for a mixture of a lognormal and a Pareto r.v.
}
\examples{
ySim <- rLnormParMix(100,.5,0,1,4,1.5)
}
\keyword{mixture.}
