% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OASA.R
\name{OASA}
\alias{OASA}
\title{Orthogonal-Array-Based Simulated Annealing}
\usage{
OASA(
  OA,
  N = 10,
  T0 = 10,
  rate = 0.1,
  Tmin = 1,
  Imax = 5,
  OC = "phi_p",
  p = 15,
  q = 1,
  maxtime = 5
)
}
\arguments{
\item{OA}{An orthogonal array matrix.}

\item{N}{A positive integer, which stands for the number of iterations. The default is set to be 10. A large value of \code{N} will result a high CPU time, and it is recommended to be no greater than 500.}

\item{T0}{A positive number, which stands for the user-defined initial temperature. The default is set to be 10.}

\item{rate}{A positive percentage, which stands for temperature decrease rate, and it should be in (0,1). For example, rate=0.25 means the temperature decreases by 25\% each time. The default is set to be 10\%.}

\item{Tmin}{A positive number, which stands for the minimium temperature allowed. When current temperature becomes smaller or equal to \code{Tmin}, the stopping criterion for current loop is met. The default is set to be 1.}

\item{Imax}{A positive integer, which stands for the maximum perturbations the algorithm will try without improvements before temperature is reduced. The default is set to be 5. For the computation complexity consideration, \code{Imax} is recommended to be smaller or equal to 5.}

\item{OC}{An optimality criterion. The default setting is "phi_p", and it could be one of the following: "phi_p", "AvgAbsCor", "MaxAbsCor", "MaxProCriterion".}

\item{p}{A positive integer, which is the parameter in the phi_p formula, and \code{p} is prefered to be large. The default is set to be 15.}

\item{q}{The default is set to be 1, and it could be either 1 or 2. If \code{q} is 1, \code{dij} is the Manhattan (rectangular) distance. If \code{q} is 2, \code{dij} is the Euclidean distance.}

\item{maxtime}{A positive number, which indicates the expected maximum CPU time given by user, and it is measured by minutes. For example, maxtime=3.5 indicates the CPU time will be no greater than three and half minutes. The default is set to be 5.}
}
\value{
If all inputs are logical, then the output will be an LHD whose sizes are the same as input OA. The assumption is that the elements of OAs must be positive.
}
\description{
\code{OASA} returns an LHD matrix generated by orthogonal-array-based simulated annealing algorithm (OASA)
}
\examples{
#create an OA(9,2,3,2)
OA=matrix(c(rep(1:3,each=3),rep(1:3,times=3)),ncol=2,nrow=9,byrow = FALSE)

#Use above "OA" as the input OA to generate a 9 by 2 maximin distance LHD
#with the default setting
try=OASA(OA=OA)
try
phi_p(try)   #calculate the phi_p of "try".

#Another example
#generate a 9 by 2 nearly orthogonal LHD
try2=OASA(OA=OA,OC="MaxAbsCor")
try2
MaxAbsCor(try2)  #calculate the maximum absolute correlation.
}
\references{
Leary, S., Bhaskar, A., and Keane, A. (2003) Optimal orthogonal-array-based latin hypercubes. \emph{Journal of Applied Statistics}, \strong{30}, 585-598.
}
