% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gensynthetic.R
\name{GenSynthetic}
\alias{GenSynthetic}
\title{Generate Synthetic Data}
\usage{
GenSynthetic(n, p, k, seed)
}
\arguments{
\item{n}{Number of samples}

\item{p}{Number of features}

\item{k}{Number of non-zeros in true vector of coefficients}

\item{seed}{The seed used for randomly generating the data}
}
\value{
A list containing the data matrix X and the response vector y.
}
\description{
Generates a synthetic dataset as follows: 1) Sample every element in data matrix X from N(0,1).
2) Generate a vector B with the first k entries set to 1 and the rest are zeros. 3) Sample every element in the noise
vector e from N(0,1). 4) Set y = XB + e.
}
\examples{
data <- GenSynthetic(n=500,p=1000,k=10,seed=1)
X = data$X
y = data$y
}
