% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.pc.knockoff.R
\name{create.pc.knockoff}
\alias{create.pc.knockoff}
\title{Create PC Knockoffs}
\usage{
create.pc.knockoff(X, pc.num)
}
\arguments{
\item{X}{An input original design matrix.}

\item{pc.num}{The number of pricial components to be used for generating knockoff matrices.}
}
\value{
A principal component knockoff matrix.
}
\description{
Create non-parametric knockoffs based on principal component regression and residuals permutation.
}
\examples{
set.seed(10)
X <- matrix(rnorm(100), nrow = 10)
tmp <- create.pc.knockoff(X = X, pc.num = 5)
}
