% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.SSModel.R
\name{[<-.SSModel}
\alias{[<-.SSModel}
\alias{[.SSModel}
\title{Extract or Replace Parts of a State Space Model}
\usage{
\method{[}{SSModel}(x, element, states, etas, series, times,
  ...) <- value

\method{[}{SSModel}(x, element, states, etas, series, times, drop = TRUE,
  ...)
}
\arguments{
\item{x}{Object of class \code{SSModel}.}

\item{element}{Which element(s) is chosen.  Typical values are \code{"y"}, 
\code{"Z"}, \code{"H"}, \code{"T"}, \code{"R"}, \code{"Q"}, \code{"a1"}, 
\code{"P1"}, \code{"P1inf"}, and \code{"u"}. See details.}

\item{states}{Which states are chosen. Either a numeric vector containing the indices of the
states, or a character vector defining the types of the states. Possible choices are
\code{"all"},  \code{"level"}, \code{"slope"},
\code{"trend"},  \code{"regression"}, \code{"arima"}, \code{"custom"},
\code{"cycle"} or \code{"seasonal"}, where \code{"trend"} extracts all states relating to trend.
 These can be combined. Default is \code{"all"}.}

\item{etas}{Which disturbances eta are chosen. Used for elements \code{"R"} and \code{"Q"}.
  Either a numeric vector containing the indices of the etas, or a character vector defining the
  types of the etas. Possible choices are \code{"all"},  \code{"level"}, \code{"slope"},
  \code{"trend"},  \code{"regression"}, \code{"arima"}, \code{"custom"},
  \code{"cycle"} or \code{"seasonal"}, where \code{"trend"} extracts all etas relating to trend.
These can be combined. Default is \code{"all"}.}

\item{series}{Numeric. Which series are chosen. Used for elements
\code{"y"}, \code{"Z"}, and \code{"u"}.}

\item{times}{Numeric. Which time points are chosen.}

\item{...}{Ignored.}

\item{value}{A value to be assigned to x.}

\item{drop}{Logical. If \code{TRUE} (default) the result is coerced to the lowest possible
dimension.}
}
\value{
A selected subset of the chosen element or a value.
}
\description{
S3 methods for getting and setting parts of object of class
\code{SSModel}. These methods ensure that dimensions of system matrices are
not altered.
}
\details{
If \code{element} is not one of 
\code{"y"}, \code{"Z"}, \code{"H"}, \code{"T"}, \code{"R"}, \code{"Q"}, 
\code{"a1"}, \code{"P1"}, \code{"P1inf"}, \code{"u"},
the default single bracket list extraction 
and assignments (\code{x[element]} and \code{x[element] <- value}) 
are used (and other arguments are ignored).

If \code{element} is one of 
\code{"y"}, \code{"Z"}, \code{"H"}, \code{"T"}, \code{"R"}, \code{"Q"}, 
\code{"a1"}, \code{"P1"}, \code{"P1inf"}, \code{"u"} and if the arguments 
\code{states}, \code{etas}, \code{times} and \code{series} are 
all missing, the double bracket list 
extraction \code{x[[element]]} and modified double bracket list assignment
\code{x[[element]][] <- value} are used.

If neither of above holds, then for example in case of \code{element = Z} 
the extraction is of form \code{x$Z[series, states, times, drop]}.
}
\examples{
set.seed(1)
model <- SSModel(rnorm(10) ~ 1)
model["H"]
model["H"] <- 10
# H is still an array:
model["H"]
logLik(model)
model$H <- 1
# model["H"] throws an error as H is now scalar:
model$H
logLik(model, check.model = TRUE) #with check.model = FALSE R crashes!
}
