% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ItemResponeTrees-package.R
\docType{package}
\encoding{UTF-8}
\name{ItemResponseTrees-package}
\alias{ItemResponseTrees-package}
\alias{_PACKAGE}
\alias{ItemResponseTrees}
\title{IR-Tree Modeling in mirt, Mplus, or TAM}
\description{
Item response tree (IR-tree) models are a class of item response theory (IRT)
models that assume that the responses to polytomous items can best be
explained by multiple psychological processes (e.g., Böckenholt, 2012,
\url{https://dx.doi.org/10.1037/a0028111}). The package 'ItemResponseTrees'
allows to fit such IR-tree models in
\href{https://cran.r-project.org/package=mirt}{mirt},
\href{https://cran.r-project.org/package=MplusAutomation}{Mplus}, or
\href{https://cran.r-project.org/package=TAM}{TAM}. The package automates some of
the hassle of IR-tree modeling by means of a consistent syntax. This allows
new users to quickly adopt this model class, and this allows experienced
users to fit many complex models effortlessly.
}
\references{
Böckenholt, U. (2012). Modeling multiple response processes in
judgment and choice. \emph{Psychological Methods}, \emph{17}(4), 665–678.
https://doi.org/10.1037/a0028111

Plieninger, H. (2020). Developing and applying IR-tree models:
Guidelines, caveats, and an extension to multiple groups. \emph{Organizational
Research Methods}. Advance online publication.
https://doi.org/10.1177/1094428120911096
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/hplieninger/ItemResponseTrees}
  \item Report bugs at \url{https://github.com/hplieninger/ItemResponseTrees/issues}
}

}
\author{
Hansjörg Plieninger
}
\keyword{internal}
