% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrangling_issues.R
\name{new_issue}
\alias{new_issue}
\title{Create a new \code{IssueTB} object}
\usage{
new_issue(
  title,
  body,
  number,
  state = c("open", "closed"),
  created_at = Sys.Date(),
  labels = NULL,
  milestone = NULL,
  issue = list(),
  repo = NULL,
  owner = NULL,
  ...
)
}
\arguments{
\item{title}{a string. The title of the issue.}

\item{body}{a string. The title of the issue.}

\item{number}{a string. The title of the issue.}

\item{state}{a character string that is either \code{"open"} (by default) if
the issue is still open or \code{"closed"} if the issue is now closed.}

\item{created_at}{a date. The title of the issue.}

\item{labels}{a vector string (or missing). The labels of the issue.}

\item{milestone}{a string (or missing). The milestone of the issue.}

\item{issue}{a list representing the object.}

\item{repo}{A character string specifying the GitHub repository name (only
taken into account if \code{source} is set to \code{"online"}).
Defaults to the package option \code{IssueTrackeR.repo}.}

\item{owner}{A character string specifying the GitHub owner (only taken
into account if \code{source} is set to \code{"online"}).
Defaults to the package option \code{IssueTrackeR.owner}.}

\item{\dots}{Other information we would like to add to the issue.}
}
\value{
a \code{IssueTB} object.
}
\description{
Create a new \code{IssueTB} object
}
\examples{

# Empty issue
issue1 <- new_issue()

# Custom issue
issue2 <- new_issue(
    title = "Nouvelle issue",
    body = "Un nouveau bug pour la fonction...",
    number = 47,
    created_at = Sys.Date()
)

issue3 <- new_issue(issue = issue2)

}
