% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_ProcessResults.R
\name{ProcessResultsContinuous}
\alias{ProcessResultsContinuous}
\title{Retrieve significant pairs (aka filter out nonsignificant pairs) 
based on value of analyte:type interaction coefficient from linear model}
\usage{
ProcessResultsContinuous(
  inputResults,
  interactionCoeffPercentile = 0.1,
  pvalCutoff = 0.05,
  rsquaredCutoff = 0
)
}
\arguments{
\item{inputResults}{IntLimResults object with model results: output of RunIntLim}

\item{interactionCoeffPercentile}{percentile cutoff for interaction coefficient
default bottom 10 percent (high negative coefficients) and top 10 percent (high positive coefficients)}

\item{pvalCutoff}{cutoff of FDR-adjusted p-value for filtering (default 0.05)}

\item{rsquaredCutoff}{cutoff of R-squared value for filtering (default 0, no filtering)}
}
\value{
A data frame with the following columns for each pair of analytes:
"Analyte1", "Analyte2", "interaction_coeff", "Pval", "FDRadjPval", and "rsquared".
Optionally, coefficients for each covariate may also be included.
}
\description{
Retrieve significant pairs (aka filter out nonsignificant pairs) 
based on value of analyte:type interaction coefficient from linear model
}
