% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plottingfunctions.R
\name{PermutationPairSummary}
\alias{PermutationPairSummary}
\title{Return the number of significant analytes / pairs per permutation and the number 
of permutations in which each analyte is significant.
If plot = TRUE, show a box plot of number of significant analytes over permutations, 
overlaid with the number of significant analytes in the original data.}
\usage{
PermutationPairSummary(inputResults, permResults, plot)
}
\arguments{
\item{inputResults}{Data frame with model results (output of ProcessResults())}

\item{permResults}{An object of type PermutationResults (output of PermuteIntLIM())}

\item{plot}{Whether or not to show the boxplot. Default is TRUE.}
}
\value{
A data frame that includes each significant pair from the unpermuted 
data and the number of times that pair was significant in the permuted data.
}
\description{
Return the number of significant analytes / pairs per permutation and the number 
of permutations in which each analyte is significant.
If plot = TRUE, show a box plot of number of significant analytes over permutations, 
overlaid with the number of significant analytes in the original data.
}
