% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{LinkBasedClustering}
\alias{LinkBasedClustering}
\title{Link based clustering}
\usage{
LinkBasedClustering(List, type = c("data", "dist", "clust"),
  distmeasure = c("tanimoto", "tanimoto"), normalize = c(FALSE, FALSE),
  method = c(NULL, NULL), clust = "agnes", linkage = c("flexible",
  "flexible"), alpha = 0.625, nrclusters = c(7, 7), gap = FALSE,
  maxK = 15, linkBasedMethod = c("cts", "srs", "asrs"), decayfactor = 0.8,
  niter = 5, linkBasedLinkage = "ward", waitingtime = 300,
  file_number = 0, executable = FALSE)
}
\arguments{
\item{List}{A list of data matrices. It is assumed the rows are corresponding with the objects.}

\item{type}{indicates whether the provided matrices in "List" are either data matrices, distance
matrices or clustering results obtained from the data. If type="dist" the calculation of the distance
matrices is skipped and if type="clusters" the single source clustering is skipped.
Type should be one of "data", "dist" or"clusters".}

\item{distmeasure}{A vector of the distance measures to be used on each data matrix. Should be one of "tanimoto", "euclidean", "jaccard", "hamming". Defaults to c("tanimoto","tanimoto").}

\item{normalize}{Logical. Indicates whether to normalize the distance matrices or not, defaults to c(FALSE, FALSE) for two data sets. This is recommended if different distance types are used. More details on normalization in \code{Normalization}.}

\item{method}{A method of normalization. Should be one of "Quantile","Fisher-Yates", "standardize","Range" or any of the first letters of these names. Default is c(NULL,NULL) for two data sets.}

\item{clust}{Choice of clustering function (character). Defaults to "agnes".}

\item{linkage}{Choice of inter group dissimilarity (character) for each data set. Defaults to c("flexible", "flexible") for two data sets.}

\item{alpha}{The parameter alpha to be used in the "flexible" linkage of the agnes function. Defaults to 0.625 and is only used if the linkage is set to "flexible"}

\item{nrclusters}{The number of clusters to divide each individual dendrogram in. Default is c(7,7) for two data sets.}

\item{gap}{Logical. Whether the optimal number of clusters should be determined with the gap statistic. Defaults to FALSE.}

\item{maxK}{The maximal number of clusters to investigate in the gap statistic. Default is 15.}

\item{linkBasedMethod}{The method to be performed: "cts", "srs", "asrs".}

\item{decayfactor}{The decay factor to be specified for the methods. Defaults to 0.8.}

\item{niter}{The number of iterations. Default is 5.}

\item{linkBasedLinkage}{The linkage to be used in the final clustering. Default is "ward".}

\item{waitingtime}{The time in seconds to wait until the MATLAB results are generated. Defaults to 300.}

\item{file_number}{The specific file number to be placed as a tag in the file generated by MATLAB. Defaults to 00.}

\item{executable}{Logical. Whether the MATLAB functions are performed via an executable on the command line (TRUE, only possible for Linux systems) or by calling on MATLAB directly (FALSE). Defaults to FALSE. The files LinkBasedClusteringcts.m (cts), LinkBasedClusteringsrs.m (srs), LinkBasedClusteringasrs.m (asrs) and and MetisAlgorithm.m are present in the inst folder to be transformed in executables.}
}
\value{
The returned value is a list of two elements:
\item{DistM}{The resulting distance matrix}
\item{Clust}{The resulting clustering}
The value has class 'LinkBased'.
}
\description{
The \code{LinkBasedClustering} includes the ensemble clustering methods cts, srs and asrs which are voting-based consensus methods.
}
\details{
\insertCite{Iam-on2010}{IntClust} describe three methods for link-based clustering based on a co-association matrix: 
Connected-Triple Based Similarity (CTS), SimRank Based Similarity (SRS) and approximate SimRank-based similarity (ASRS). 
The methods compute a similarity matrix based on additional information. CTS incorporates information regarding the shared third 
link between two objects. SRS works based on the assumption that neighbours are similar if their neighbours are similar as well.
The ASRS is introduced as a more efficient implementation of SRS. The \code{R} code calls on the MATLAB code provided by \insertCite{Iam-on2010}{IntClust}. The MATLAB functions are included in the inst folder and should be located in the working directory. Shell script for the executable can be found in the inst folder as well.
}
\examples{
\dontrun{
data(fingerprintMat)
data(targetMat)
L=list(fingerprintMat,targetMat)

MCF7_cts=LinkBasedClustering(List=L,type="data",distmeasure=c("tanimoto", "tanimoto")
,normalize=c(FALSE,FALSE),method=c(NULL,NULL),clust="agnes",linkage = c("flexible",
"flexible"),alpha=0.625,nrclusters=c(7,7),gap = FALSE, maxK = 15,linkBasedMethod="cts",
decayfactor=0.8,niter=5,linkBasedLinkage="ward",waitingtime=300,file_number=00)
}
}
\references{
\insertRef{Iam-on2010}{IntClust}
}
