% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gammaStat.R, R/generics.R, R/scoreImputedSet.R
\name{ImputeStat}
\alias{ImputeStat}
\alias{ImputeStat.GammaImputedData}
\alias{ImputeStat.GammaImputedSet}
\alias{ImputeStat.ScoreImputedSet}
\title{S3 generic to fit model(s) to risk score/gamma Imputed objects}
\usage{
\method{ImputeStat}{GammaImputedData}(object, method = c("Cox", "weibull",
  "exponential")[1], formula = NULL, ...)

\method{ImputeStat}{GammaImputedSet}(object, method = c("Cox", "weibull",
  "exponential")[1], formula = NULL, ..., parallel = c("no", "multicore",
  "snow")[1], ncpus = 1L, cl = NULL)

ImputeStat(object, method = c("logrank", "Wilcoxon", "Cox", "weibull",
  "exponential")[1], formula, ...)

\method{ImputeStat}{ScoreImputedSet}(object, method = c("logrank", "Wilcoxon",
  "Cox")[1], formula = NULL, ..., parallel = c("no", "multicore",
  "snow")[1], ncpus = 1L, cl = NULL)
}
\arguments{
\item{object}{A \code{ScoreImputedData}, \code{ScoreImputedSet}, \code{GammaImputedData} or \code{GammaImputedSet} object 
to fit the model to}

\item{method}{The type of statistical model to fit. There are three methods which can be performed when using
Risk Score imputation   \cr
"logrank": a logrank test using \code{survival::survdiff} \cr
"Wilcoxon": Peto & Peto modification of the Gehan-Wilcoxon test using \code{survival::survdiff}
with \code{rho=1} \cr
"Cox": Fit a cox model using \code{survival::coxph}  \cr 

For gamma imputation the model can be "Cox" (using \code{survival::coxph}), 
"weibull" or "exponential" both using \code{survival::coxph}}

\item{formula}{The model formula to fit.
If no formula argument is used, then object$default.formula will be used.
For risk score imputation this is \code{~ treatment.group} and for gamma imputation
this is the formula used when fitting the Cox model

For \code{method="Cox"}, additional covariates can be included by explictily giving a 
formula argument. For logrank/Wilcoxon only additional strata terms can be
included. 
 
In all cases only the right hand side of the formula is required
The survival object on the left hand side is created automatically
E.g. for a Cox model could use formula=~arm + covar1. The cluster and tt options cannot be used
See the vignettes for further details}

\item{...}{Additional arguments which are passed into the model fit function}

\item{parallel}{The type of parallel operation to be used (if any), can be used for \code{GammaImputedSet} and \code{ScoreImputedSet}}

\item{ncpus}{integer: number of processes to be used in parallel operation: typically one would chose this to be
the number of available CPUs, can be used for \code{GammaImputedSet} and \code{ScoreImputedSet}.}

\item{cl}{An optional parallel or snow cluster for use if \code{parallel="snow"}. If not supplied, a
cluster on the local machine is created for the duration of the call, can be used for \code{GammaImputedSet} and \code{ScoreImputedSet}.}
}
\description{
S3 generic to fit model(s) to risk score/gamma Imputed objects
}
\seealso{
\code{\link{ScoreStat.object}} \code{\link{ScoreImputedData.object}}
}

