% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluateMatched.R
\name{productChanges}
\alias{productChanges}
\title{Product ID's for appearing/disappearing products}
\usage{
productChanges(x, pervar, prodID)
}
\arguments{
\item{x}{A dataframe containing price, quantity, a time period identifier
and a product identifier. It must have column names.}

\item{pervar}{A character string for the name of the time variable. This variable
must contain integers starting at period 1 and increasing in increments of 1 period.
There may be observations on multiple products for each time period.}

\item{prodID}{A character string for the name of the product identifier}
}
\value{
a list containing one element for each time period, each element of
which contains two vectors (one for appearing products, and one for disappearing products)
}
\description{
This function will give the product ID's of products that appear
or disappear in each period.
}
\examples{
# create a dataset with some missing products
df <- CES_sigma_2[-c(3,4,15),]

# show the products that changed
productChanges(df, "time", "prodID")

}
