% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticity.R
\name{elasticity}
\alias{elasticity}
\title{Computes the elasticity of substitution}
\usage{
elasticity(x, pvar, qvar, pervar, prodID, compIndex = "ces",
  lower = -20, upper = 20)
}
\arguments{
\item{x}{A dataframe}

\item{pvar}{A character string for the name of the price variable}

\item{qvar}{A character string for the name of the quantity variable}

\item{pervar}{A character string for the name of the time variable. This variable
must contain integers starting at period 1 and increasing in increments of 1 period.
There may be observations on multiple products for each time period.}

\item{prodID}{A character string for the name of the product identifier}

\item{compIndex}{The index number with which the CES index will be equated
to calcuate the elasticity. Acceptable options are lloydmoulton, fisher
or satovartia. The lloydmoulton option equates the 'base period' lloyd-moulton
index with the 'current period' lloyd-moulton index.}

\item{lower}{lower limit to search for sigma.}

\item{upper}{upper limit to search for sigma.}
}
\value{
A list with three elements: sigma (the average elasticity
over all time periods); allsigma (a T-1 by 1 matrix of the estimated
elasticities for each time period, except period one); and diff
(the value of the difference between the two indexes, check this is zero
for all time periods).
}
\description{
A function to estimate the elasticity of substitution
}
\examples{
elasticity(CES_sigma_2,pvar="prices",qvar="quantities",pervar="time",
prodID = "prodID")
}
