% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ITNadjust_function.R
\name{ITNadjust}
\alias{ITNadjust}
\title{Adjust ITN}
\usage{
ITNadjust(MATlist, j)
}
\arguments{
\item{MATlist}{A list of ITN matrices}

\item{j}{Element of matrix list to compare with others}
}
\value{
Matrix
}
\description{
This function adjusts ITN matrices so they are the same size
}
\examples{
\donttest{
##Create a list of random matrices (of different sizes)
##Labels - letters of alphabet (can represent actor names)
mat1<- matrix(round(runif(10*10)), 10, 10)
rownames(mat1)<-LETTERS[1:10]
colnames(mat1)<-LETTERS[1:10]

mat2<- matrix(round(runif(10*10)), 10, 10)
rownames(mat2)<-LETTERS[10:19]
colnames(mat2)<-LETTERS[10:19]

mat3<- matrix(round(runif(12*12)), 12, 12)
rownames(mat3)<-LETTERS[15:26]
colnames(mat3)<-LETTERS[15:26]

##Create matrix list
MATlist<-list(mat1,mat2,mat3)

##Adjust matrix 1 so that it has additional rows/actors not
##in the original matrix

mat1adjust<-ITNadjust(MATlist,1)
}
}
