% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISRaD.flatten.R
\name{ISRaD.flatten}
\alias{ISRaD.flatten}
\title{ISRaD.flatten}
\usage{
ISRaD.flatten(database, table)
}
\arguments{
\item{database}{ISRaD dataset object: e.g. ISRaD_data, or ISRaD_extra}

\item{table}{ISRaD table of interest ("flux", "layer", "interstitial", "fraction", "incubation"). Must be entered with "".}
}
\value{
A dataframe with nrow = nrow(table) and ncol = sum(ncol(meta), ncol(site), ncol(profile), ..., ncol(table))
}
\description{
Joins tables in ISRaD based on linking variables and returns flat data frame/s
}
\details{
ISRaD.extra.flatten generates 2-dimensional matrices for user-specified ISRaD tables by joining higher level tables (metadata, site, profile, layer) to lower level tables (layer, fraction, incubation, flux, interstitial).
}
\examples{
# Load example dataset Gaudinski_2001
database <- ISRaD::Gaudinski_2001
fractions <- ISRaD.flatten(database, "fraction")
layers <- ISRaD.flatten(database, "layer")
}
\author{
J. Beem-Miller
}
