% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISRaD.extra.fill_14c.R
\name{ISRaD.extra.fill_14c}
\alias{ISRaD.extra.fill_14c}
\title{ISRaD.extra.fill_14c}
\usage{
ISRaD.extra.fill_14c(database)
}
\arguments{
\item{database}{ISRaD dataset object.}
}
\value{
ISRaD_data object with filled delta 14C columns.
}
\description{
Fills delta 14C from fraction modern if delta 14C not reported.
}
\details{
Warning: xxx_obs_date_y columns must be filled for this to work!
}
\examples{
# Load example dataset Gaudinski_2001
database <- ISRaD::Gaudinski_2001
# Note that flx_14c values are NA
is.na(database$flux$flx_14c)
# Fill dates
database.x <- ISRaD.extra.fill_dates(database)
# Fill delta 14C from fraction modern
database.x <- ISRaD.extra.fill_14c(database.x)
# Column flx_14c in the "flux" table is now filled
is.na(database$flux$flx_14c)
}
\references{
Stuiver and Polach, 1977
}
\author{
J. Beem-Miller & A. Hoyt
}
