% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{SimulateItemParameters}
\alias{SimulateItemParameters}
\alias{simulateItemParameters}
\title{Simulates item parameters for UIRT models.}
\usage{
simulateItemParameters(items, model, dims = 1, boundaries = NULL)
}
\arguments{
\item{items}{Number of items to generate}

\item{model}{A string with the model to simulate, please refer to the model documentation in irtpp documentation.}

\item{dims}{Optional. The number of dimensions to simulate in the test if the model is multidimensional}

\item{boundaries}{Optional. The kind of boundaries that are specified for the parameters.}
}
\value{
A list containing the values of the parameters simulated according to the chosen model.
}
\description{
Simulates item parameters depending on a model
}
\examples{
## Simulation for a dimension
# simulateItemParameters(10, "2Pl")
## For three-dimensional simulation
# simulateItemParameters(10, "2Pl", dims = 3)
}
\seealso{
\code{\link{simulateTest}}, \code{\link{simulateTest.file}}
}

