% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ILSAready.R
\name{ILSAready}
\alias{ILSAready}
\alias{ILSAreadylocal}
\title{Download and prepare ILSA data}
\usage{
ILSAready(
  study,
  year,
  outputdir = getwd(),
  MBlistlimit = 200,
  quiet = FALSE,
  agreeLicense = FALSE
)

ILSAreadylocal(
  inputdir = getwd(),
  outputdir = getwd(),
  filetype = c("rds", "zsav", "sav"),
  quiet = FALSE,
  MBlistlimit = 200
)
}
\arguments{
\item{study}{a string indicating the name of the study. For available studies
check the description of this function.}

\item{year}{a numeric value indicating the year of the study.}

\item{outputdir}{the directory where the merged data will be saved.}

\item{MBlistlimit}{a numerical value indicating the allowed limit of the
combined storage of the files of one type for merging through a list.
Values over the limit will be merged through a matrix, which will be slower
but uses less memory. Default is \code{200}.}

\item{quiet}{a logical value indicating if progress status should be
shown. Default is \code{FALSE}.}

\item{agreeLicense}{a logical value indicating if you agree with
the Disclaimer and License Agreement file from www.iea.nl. If \code{FALSE},
you will be prompted to agree with it or else data will not be downloaded.
Default is \code{FALSE}.}

\item{inputdir}{a string indicating the path where ILSA 'SPSS' files are stored.}

\item{filetype}{a string indicating the type of file to be saved, it can
be \code{"rds"}, \code{"zsav"}, or \code{"sav"}.}
}
\value{
Saves merged and renamed ILSA data.
}
\description{
Downloads ILSA data, merges it, combines students and adds school information.
This function is a wrapper for \code{\link{ILSAdownload}}, \code{\link{ILSAmerge}},
\code{\link{ILSArename}}, \code{\link{combineStudents}}, and \code{\link{addSchools}}. 
To see which ILSA are available for this function use \code{\link{availableILSA}}.
If data is already downloaded you can use \code{\link{ILSAreadylocal}}.
}
\examples{
dir.create(file.path(tempdir(),"timssadv"),showWarnings = FALSE)
output <- file.path(tempdir(),"timssadv")

input <- system.file("extdata/timssadv", package = "ILSAmerge")

ILSAreadylocal(inputdir = input, outputdir = output)

}
