% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d-gev.R
\name{rgev.d}
\alias{rgev.d}
\title{Generation of random variables from d-GEV}
\usage{
rgev.d(n, mut, sigma0, xi, theta, eta, d, tau = 0, eta2 = NULL)
}
\arguments{
\item{n}{number of random variables per duration}

\item{mut, sigma0, xi}{numeric value, giving modified location, modified scale and shape parameter}

\item{theta}{numeric value, giving duration offset (defining curvature of the IDF curve)}

\item{eta}{numeric value, giving duration exponent (defining slope of the IDF curve)}

\item{d}{positive numeric value, giving duration}

\item{tau}{numeric value, giving intensity offset \eqn{\tau} (defining flattening of the IDF curve). Default: \eqn{\tau=0}.}

\item{eta2}{numeric value, giving a second duration exponent \eqn{\eta_2} (needed for multiscaling). Default: NULL, treated as \eqn{\eta_2=\eta}.}
}
\value{
list containing vectors of random variables.  
The first element of the list are the random values for the first given duration etc.
Note that the random variables for different durations are nor ordered (contrary to precipitation maxima of different durations).
}
\description{
Generation of random variables following duration-dependent GEV.
}
\details{
For details on the d-GEV and the parameter definitions, see \link{IDF-package}
}
\examples{
# random sample for one duration
rgev.d(n=100,mut=4,sigma0=2,xi=0,theta=0.1,eta=0.3,d=1)

# compare randomn samples for different durations
ds <- c(1,4)
samp <- lapply(ds,rgev.d,n=100,mut=4,sigma0=2,xi=0,theta=0.1,eta=0.3)

hist(samp[[1]],breaks = 10,col=rgb(1,0,0,0.5),freq = FALSE
     ,ylim=c(0,0.3),xlim=c(3,20),xlab='x',main = 'Random d-GEV samples')
hist(samp[[2]],breaks = 10,add=TRUE,col=rgb(0,0,1,0.5),freq = FALSE)
legend('topright',fill = c(rgb(1,0,0,0.5),rgb(0,0,1,0.5)),
legend = paste('d=',1:2,'h'),title = 'Duration')
}
\seealso{
\code{\link{pgev.d}}, \code{\link{qgev.d}}, \code{\link{dgev.d}}
}
