% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IATanalytics.R
\name{IATanalytics}
\alias{IATanalytics}
\title{Function to Analyze Raw Data from an Implicit Association Test (IAT)}
\usage{
IATanalytics(IAT, Trials, First)
}
\arguments{
\item{IAT}{The name of the dataset to be analyzed.}

\item{Trials}{The number of trials across your entire IAT. The default is set to 220, which is typical of most IATs.}

\item{First}{Whether participants first sorted Congruent or Incongruent trials. The default is set to Congruent.}
}
\description{
This function is designed to analyze raw data from an Implicit Association Test (IAT). The only required input is the name of the dataset, but you can also specify manually the number of trials in your IAT (e.g., for Brief IATs) or whether the participant first saw incongruent category pairings. Refer to the package's DESCRIPTION file for more detailed information (or contact me directly at research@danielstorage.com).
}
\examples{
IATanalytics(sampledata)
IATanalytics(IAT=sampledata)
IATanalytics(sampledata, First="Congruent")
IATanalytics(sampledata, First="Incongruent")
}
\keyword{IAT}
