% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/POR_apply_annual_lowflow_stats.R
\name{POR_apply_annual_lowflow_stats}
\alias{POR_apply_annual_lowflow_stats}
\title{Calculate 10-year and 2-year return periods of a streamflow time series}
\usage{
POR_apply_annual_lowflow_stats(annual_min)
}
\arguments{
\item{annual_min}{'numeric' vector or data.frame. Vector or data.frame with columns of annual
n-day minimum streamflows.}
}
\value{
data.frame with 10-year and 2-year return period of n-day streamflows.
}
\description{
Calculates 10-year and 2-year return periods of a streamflow time series from
annual n-day low streamflow values and returns a data.frame in the format of other
period-of-record (POR) metrics.
}
\details{
\code{POR_apply_POR_lowflow_metrics} is a helper function that applies the \code{\link{POR_calc_lp3_quantile}}
function to the data.frame of n-day moving averages, which can be computed during pre-processing
step using \code{\link{preproc_precondition_data}} and \code{\link{calc_annual_flow_stats}}, or \code{\link{preproc_main}} for
both observed and modeled data. This function returns a data.frame with the 10-year and 2-year
return period streamflows for each n-day low streamflow in the input data.frame.
}
\examples{
POR_apply_annual_lowflow_stats(annual_min = example_annual[ , c("low_q1", "low_q30")])

}
\seealso{
\code{\link{POR_calc_lp3_quantile}}, \code{\link{preproc_precondition_data}},
\code{\link{calc_annual_flow_stats}}, \cr
\code{\link{preproc_main}}
}
\keyword{annual-statistics}
\keyword{period-of-record}
