% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delta_BD.R
\name{delta_BD}
\alias{delta_BD}
\title{delta_BD calculation}
\usage{
delta_BD(physeq, control_expr, n = 20, BD_min = NULL, BD_max = NULL)
}
\arguments{
\item{physeq}{Phyloseq object}

\item{control_expr}{An expression for identifying unlabeled control
samples in the phyloseq object (eg., "Substrate=='12C-Con'")}

\item{n}{How many evenly-spaced buoyant density values to use for linear
interpolation of abundances.}

\item{BD_min}{The minimum BD value of the BD range used for OTU abundance interpolation.
If NULL, then BD_min will be the minimum of all BD values in the phyloseq object.}

\item{BD_max}{The maximum BD value of the BD range used for OTU abundance interpolation.
If NULL, then BD_max will be the maximum of all BD values in the phyloseq object.}
}
\value{
data.frame with delta_BD values for each OTU. 'CM' stands for 'center of mass'.
}
\description{
Calculate delta_BD as described in
\href{http://www.ncbi.nlm.nih.gov/pmc/articles/PMC4867679/}{Pepe-Ranney et al., 2016}.
}
\details{
Basically, the abundance of each OTU is interpolated at specific BD values in order to
have abundance values at consistent points across gradients (gradient fraction BDs
normally vary from gradient to gradient). The center of mass (CM) is calculcated from these
interpolated values, which is the weighted mean BD with interpolated OTU abundances
used as weights (ie., where in the density gradient contains the 'center' of the OTU
abundance distribution). Delta_BD is then calculated by substracting the CM for the
unlabeled control gradient from the labeled treatment gradient.

The delta_BD calculation will be a comparison between unlabled control and labeled
treatment samples. These samples are distinguished from each other with the
'control_expr' parameter. NOTE: if multiple gradients fall into the control or
treatment category, they will be treated as one gradient (which may be OK if
you want to combine replicate gradients).

NaN values may occur due low abundances.

The BD range used for interpolation is set by the min/max of all buoyant density
values in the phyloseq object (standardize across).
}
\examples{
data(physeq_S2D2_l)
# just selecting 1 treatment-control comparison
physeq = physeq_S2D2_l[[1]]

\dontrun{
# calculating delta_BD
df = delta_BD(physeq, control_expr='Substrate=="12C-Con"')
head(df)

# In this example, the replicate gradients will be combined for treatments/controls
data(physeq_rep3)
df = delta_BD(physeq_rep3, control_expr='Treatment=="12C-Con"')
head(df)
}

}

