% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HTSSIP_sim.R
\name{HTSSIP_sim}
\alias{HTSSIP_sim}
\title{Simulate a HTS-SIP dataset}
\usage{
HTSSIP_sim(locs, params, responseModel = "gaussian", countModel = "poisson",
  meta = NULL, parallel = FALSE, ...)
}
\arguments{
\item{locs}{Buoyant densities of each gradient fraction}

\item{params}{A matrix of parameters for \code{coenocliner::coenocline()}.
See that function's documentation for more details.}

\item{responseModel}{See \code{coenocliner::coenocline()}}

\item{countModel}{See \code{coenocliner::coenocline()}}

\item{meta}{Data.frame object of metadata to add to \code{sample_data} table.
The data.frame object must have a 'Gradient' column, which is used for joining
with \code{dplyr::left_join()}.}

\item{parallel}{Parallel processing. See \code{.parallel} option in
\code{dplyr::mdply()} for more details.}

\item{...}{Other parameters passed to \code{coenocliner::coenocline()}}
}
\value{
A phyloseq object
}
\description{
This is a simple method for simulating high thoughput sequencing
stable isotope probing datasets and is mainly used for package testing
purposes. See \code{SIPSim} for more detailed and simulation pipeline.
}
\examples{
# setting parameters for tests
set.seed(2)
M = 10                                  # number of species
ming = 1.67                             # gradient minimum...
maxg = 1.78                                # ...and maximum
nfrac = 24                                 # number of gradient fractions
locs = seq(ming, maxg, length=nfrac)       # gradient locations
tol  = rep(0.005, M)                       # species tolerances
h    = ceiling(rlnorm(M, meanlog=11))    # max abundances
## creating parameter matrices for each density gradient
opt1 = rnorm(M, mean=1.7, sd=0.005)      # species optima
params1 = cbind(opt=opt1, tol=tol, h=h)  # put in a matrix
opt2 = rnorm(M, mean=1.7, sd=0.005)      # species optima
params2 = cbind(opt=opt2, tol=tol, h=h)  # put in a matrix
param_l = list(
  '12C-Con_rep1' = params1,
  '13C-Cel_rep1' = params2
)
\dontrun{
# simulating phyloseq object
physeq = HTSSIP_sim(locs, param_l)
physeq
}

}

