% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gendata.r
\name{gendata_MLR}
\alias{gendata_MLR}
\title{Generate Simulated Data with Multinomial Logistic Regression Model}
\usage{
gendata_MLR(n, p, NC = 3, nu = 2, w = 1, X = NULL, betas = NULL)
}
\arguments{
\item{n}{Number of observations.}

\item{p}{Number of features.}

\item{NC}{Number of classes for response variables.}

\item{nu, w}{If \code{betas} is not supplied (default), the regression coefficients are generated with 
t prior with df = \code{nu}, scale = \code{sqrt(w)}; will be ignored if \code{betas} is supplied.}

\item{X}{The design matrix; will be generated from standard normal distribution if not supplied.}

\item{betas}{User supplied regression coefficients.}
}
\value{
A list contains input matrix \code{X}, response variables \code{y}, and regression coefficients \code{deltas}.
}
\description{
This function generates the response variables \code{y} given 
optional supplied \code{X} using a multinomial logistic regression model.
}
\examples{
set.seed(12345)
dat <- gendata_MLR(n = 100, p = 10)
ggplot2::qplot(dat$y, bins = 6)
corrplot::corrplot(cor(dat$X))

}
\seealso{
\code{\link{gendata_FAM}}
}
