.onAttach <-
function (...) 
{
    date <- date()
    x <- regexpr("[0-9]{4}", date)
    this.year <- substr(date, x[1], x[1] + attr(x, "match.length") - 
        1)
    cat("##\n## Hierarchical Summary Receiver Operating Characteristic package (HSROC)\n")
    cat("## Copyright (C) 2010-", this.year, " Ian Schiller and Nandini Dendukuri \n", 
        sep = "")
    cat("##\n## Development of HSROC package was supported by grants from the \n")
    cat("## Canadian Institutes of Health Research (MOP #89857) \n")
    cat("## and the Fonds de la Recherche en Sant Qubec. \n##\n")
    require(lattice, quietly = TRUE)
    require(coda, quietly = TRUE)
    require(MASS, quietly = TRUE)
    require(MCMCpack, quietly = TRUE)
}
.Random.seed <-
c(403L, 34L, 874314953L, 1364653691L, 1477276746L, -950969172L, 
-1677325393L, -1533317275L, 1395344668L, -772911758L, -275479059L, 
-2066347481L, 1141762638L, 1502654120L, 383345835L, 189875657L, 
180341208L, -660758394L, 82390369L, 2115477747L, -984002718L, 
318417364L, -874455849L, 695377613L, 1030739556L, 728978506L, 
-453123659L, 635956495L, -2076390890L, -1961081664L, -858717565L, 
-766259551L, 216055952L, -1534268562L, 571766041L, -2015443541L, 
1150763930L, 269474652L, -1754105249L, -1507319243L, -577066548L, 
581411106L, 1989157757L, -2024963977L, -456571490L, 78511192L, 
1687202235L, 1966567257L, 1051512040L, -1477307114L, -1346402671L, 
799984451L, 1954420306L, 2002188516L, 1498868519L, -1336795267L, 
315994740L, 1954557018L, -649284443L, -562016577L, 1257092422L, 
1536850896L, 187389427L, 620683537L, 1177218368L, -327733986L, 
670226921L, 1752226587L, 1432569130L, -752214452L, -1816876529L, 
916778309L, -154308868L, 1732740434L, -1789383987L, -530988409L, 
-384957074L, -315310264L, -660075701L, 70447785L, 1786869752L, 
1592809254L, -1774090175L, -1821496877L, -721108094L, 268937140L, 
-2127610057L, -1221323219L, 1624385348L, 879891562L, 1633046229L, 
-1982855057L, -700495498L, 1017246368L, 1708875619L, 1755722753L, 
366002032L, 768472846L, -1224937095L, -1365277429L, -857891270L, 
2046154044L, 1356454527L, 2055848405L, -1009115156L, -1506344638L, 
-442909027L, 554572567L, -1735456130L, 1712413240L, 538942747L, 
-392705415L, 2133477064L, -1237164298L, -1594214607L, -971493533L, 
-411482830L, -920971644L, -1953037625L, -216964707L, -32037612L, 
-674927686L, 490266117L, 816357343L, -435186074L, -2011938320L, 
50253587L, 166613169L, 1947595616L, -150953730L, 1481871497L, 
371834811L, 289261962L, -514459540L, -882959889L, -484617691L, 
-667547940L, 1138760882L, -1710854227L, 1719661415L, -548892530L, 
-1746965144L, -1327403669L, 2120793865L, -1574121064L, 810858694L, 
1808550433L, -1664773453L, -1369432030L, 781384212L, -1113178473L, 
1755721869L, -390904412L, 1616201610L, 1584243701L, 606964303L, 
-509375146L, 1760569344L, 2030041411L, -269929247L, -1007776176L, 
1342247598L, 1285322329L, 1503673963L, -459033638L, 235332764L, 
1341976223L, 1456809205L, 1534379404L, -1146470302L, 15683645L, 
-1305228617L, -1566281378L, -402114408L, -968178693L, 1643082137L, 
925356584L, 944890582L, 841615185L, -544986621L, -1185620590L, 
-943183068L, 714608103L, 889424445L, -123960140L, -2133753062L, 
1502603365L, 258097407L, -169774714L, -607017200L, 1488659379L, 
-1687265199L, 808645632L, -489786146L, -1828452567L, 1042619099L, 
315519466L, -1207060084L, -992592177L, 50741893L, -370501316L, 
2086732818L, 925543181L, -1971013561L, -2050172370L, 54739848L, 
-1983738229L, 1155883113L, -1838126024L, -138191642L, -1112972159L, 
-1653722093L, 934880194L, -1374339980L, -2049879433L, 1475816301L, 
1904806916L, -931928278L, -524569451L, 947659567L, 1441518134L, 
1839392352L, -1358728029L, -100655167L, 210451376L, -1872666930L, 
321575993L, 81085003L, 477804538L, -1813088356L, 262455314L, 
-903601280L, -1901658348L, 2002307368L, -1040457670L, -1361422384L, 
-86308244L, 603474996L, -260655982L, -1877361312L, 105828684L, 
-1637930528L, 1151819682L, -1302138968L, -1610763124L, -1054927940L, 
1292367986L, 1296536560L, 741900356L, 1439691864L, 2092109882L, 
-1419878288L, 2008879676L, 751647508L, 938729154L, 699375328L, 
-1534520196L, 364806352L, -1869425758L, -1245179352L, -1512479476L, 
-1023198276L, -1747237582L, -1055437632L, 449805876L, 73955016L, 
-1494165830L, 572784784L, 2047228652L, -440817068L, -2117144942L, 
1862769440L, 1313811404L, -1447740192L, 765733570L, -910761944L, 
-1794765908L, 1735473852L, 949872114L, -1317353936L, 1086746532L, 
-1377237576L, -1179492518L, -1071556464L, 929360764L, 1127375636L, 
-285236926L, -700120320L, 865005500L, -363613360L, 1479079202L, 
-1249534392L, -1655281652L, -1279111076L, 36321746L, -1484834304L, 
-855285420L, 1579738344L, 2094275834L, 632461008L, 510315820L, 
1379920116L, -626854510L, 67803488L, -1779648500L, 1157693152L, 
425851490L, -936206680L, 1825756748L, 685194108L, -789564110L, 
1174011504L, 788364100L, 1361875928L, -575627398L, -374803920L, 
1409452988L, -360897964L, -57226174L, 184129696L, 2124104380L, 
-1998610992L, 1788188514L, -892284184L, 1213244620L, 1074441724L, 
-1545479694L, 3618432L, 541451764L, -1131916664L, 50153274L, 
2110496592L, -1590473620L, 521809300L, 1243221074L, 1510840800L, 
314266828L, -453807968L, -828987006L, -2096547608L, -1160420628L, 
1186002236L, -54195086L, 1050412144L, -1938297820L, 151085112L, 
-1276441830L, 224967888L, -531055812L, -1723029612L, 1289498498L, 
969266624L, -873995716L, -1228801648L, 72063522L, -830280440L, 
-428533108L, -1318373604L, 1221742738L, -1036394112L, -1443151340L, 
1603060520L, -1003297222L, 1078557136L, 1370666348L, 197039028L, 
1403386898L, 1201435104L, -392461364L, 823963872L, 1577248802L, 
1234935080L, 1873475084L, -441736388L, -642133006L, 41492208L, 
1606421060L, 20975192L, 1412158266L, 610095600L, 80551612L, -455590636L, 
1278754498L, 1353875552L, 31147900L, -1172644912L, -1877885662L, 
2016282280L, 760703884L, -1374454596L, 1409263410L, 1058755136L, 
579991732L, -1419523512L, 1312513466L, -837594608L, -1158799636L, 
-1023603372L, -1301621486L, 372406688L, -1482907956L, 1938622048L, 
1102484418L, -184777944L, 408050604L, -1480454340L, -310157966L, 
1210060592L, -657418972L, -1780049096L, 1200193242L, 1560863632L, 
-664945924L, -1046064236L, 794267714L, 2072445184L, -1205881796L, 
-1214708400L, -996573022L, -102482616L, -1524237556L, 399336156L, 
2131771730L, -1020297088L, -992416684L, 1071070184L, 922391802L, 
406396752L, 1818521388L, -1473962636L, -1088815214L, 799620192L, 
298218892L, 514083680L, 460940770L, 1253811112L, -510648116L, 
2129878012L, -932908622L, -2047083024L, -1891672124L, 1164452184L, 
164279674L, -554401872L, -1831430724L, 1448567892L, 714942402L, 
-1665230816L, 912615612L, 434198096L, -1603285022L, -1128400792L, 
-1249796020L, -1967651588L, 2145155058L, -157192960L, -1254420460L, 
-2147369179L, -2038241233L, 842641896L, 664340166L, 1245955955L, 
-1469521963L, 1446483890L, 1224397184L, 1504733545L, -1377468965L, 
-424889044L, -54083782L, -2060504593L, -76495751L, 1566750478L, 
-18025764L, -1374547635L, 1840663735L, -58894784L, 501217054L, 
-302477845L, -545443475L, -1305030694L, 63887768L, -707598335L, 
1803798963L, 1757774036L, 878462434L, 576131191L, -1062259263L, 
341516102L, -855610748L, 2049709109L, -1875962849L, -1136217224L, 
1875769942L, 397133539L, 1216405669L, -2037272254L, -733907152L, 
1546453849L, 776964299L, -723355332L, -751356566L, -896843873L, 
-417379799L, 1770951870L, 512757164L, -509496579L, -259424697L, 
-248439504L, -1105269170L, 549691003L, -30806563L, -48804854L, 
1918725416L, 806642577L, -641960573L, -959589756L, -154185550L, 
-2076790777L, -2040615855L, 511032278L, -133610828L, -816225595L, 
-1165868017L, 1971217544L, 16008614L, -370111149L, 993183413L, 
-2040988654L, 611065312L, 2053832777L, 289629819L, 1102360396L, 
1824008922L, -529813809L, -1536172391L, -1228569938L, 1804165052L, 
730654765L, 1802950615L, -1063444960L, 379961214L, 679149899L, 
-1724529843L, -672480902L, -964152392L, 562702689L, 1750775059L, 
-1809621708L, -1000028350L, -1548757161L, -1256094047L, -662100122L, 
798097764L, 1886684309L, 1937051071L, -1660423848L, -2112135306L, 
-92017277L, 412829637L, 761920738L, 1676003664L, -1352755079L, 
297999275L, -1191919332L, -1256552886L, 1733329471L, -1380854135L, 
525271710L, 1080532812L, 815421213L, 76297895L, 1360788944L, 
1223599470L, 364894235L, 1552185725L, 1593909098L, -1194505720L, 
-1905480015L, 120629539L, 1277221412L, -936652590L, -207730393L, 
-407411855L, 2045088182L, -810342060L, -1153759259L, -177507857L, 
1041348904L, 1803030918L, 1951915443L, 1214972181L, -1271155854L, 
1263943616L, -47534039L, 1530784923L, 242641260L, 1541259642L, 
-2041802065L, 567486905L, -782847026L, -1055659236L, 199885453L, 
1606142711L, -1962435072L, 2031597662L, -2052951253L, 173940781L, 
-358430566L, -505832360L, -302281791L, 1594811507L, -673714796L, 
-271608798L, 701186871L, 2099111425L, -641489146L, -622453948L, 
-868954507L, 1231106015L, -309337288L, -1454496490L, -729966301L, 
-669883675L, 1015220994L, -1341701776L, 829168553L)
