% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hlm_resid.R
\name{hlm_resid.default}
\alias{hlm_resid.default}
\alias{hlm_resid.lmerMod}
\alias{hlm_resid}
\alias{hlm_resid.lme}
\title{Calculating residuals from HLMs}
\usage{
\method{hlm_resid}{default}(object, ...)

\method{hlm_resid}{lmerMod}(
  object,
  level = 1,
  standardize = FALSE,
  include.ls = TRUE,
  data = NULL,
  ...
)

\method{hlm_resid}{lme}(
  object,
  level = 1,
  standardize = FALSE,
  include.ls = TRUE,
  data = NULL,
  ...
)
}
\arguments{
\item{object}{an object of class \code{lmerMod} or \code{lme}.}

\item{...}{do not use}

\item{level}{which residuals should be extracted: 1 for within-group
(case-level) residuals, the name of a grouping factor for between-group
residuals (as defined in \code{flist} in \code{lmerMod} objects or in
\code{groups} in \code{lme} objects)}

\item{standardize}{for any level, if \code{standardize = TRUE} the
standardized residuals will be returned for any group; for level-1 only, if
\code{standardize = "semi"} then the semi-standardized level-1 residuals
will be returned}

\item{include.ls}{a logical indicating if LS residuals be included in the
return tibble. \code{include.ls = FALSE} decreases runtime substantially.}

\item{data}{if \code{na.action = na.exclude}, the user must provide the data
set used to fit the model, otherwise \code{NULL}.}
}
\description{
\code{hlm_resid} takes a hierarchical linear model fit as a \code{lmerMod} or
\code{lme} object and extracts residuals and predicted values from the model,
using Least Squares (LS) and Empirical Bayes (EB) methods. It then appends
them to the model data frame in the form of a tibble inspired by the \code{augment}
function in \code{broom}. This unified framework enables the analyst to more
easily conduct an upward residual analysis during model exploration/checking.
}
\details{
The \code{hlm_resid} function provides a wrapper that will extract
residuals and predicted values from a fitted \code{lmerMod} or \code{lme}
object. The function provides access to residual quantities already made available by
the functions \code{resid}, \code{predict}, and \code{ranef}, but adds
additional functionality. Below is a list of types of residuals and predicted
values that are extracted and appended to the model data.
\describe{
\item{\strong{level-1 residuals}}{}
\item{\code{.resid} and \code{.fitted}}{Residuals calculated using
the EB method (using maximum likelihood). Level-1 EB residuals are interrelated
with higher level residuals. Equivalent to the residuals extracted by
\code{resid(object)} and \code{predict(object)} respectively. When
\code{standardize = TRUE}, residuals are standardized by sigma components of
the model object.}
\item{\code{.ls.resid} and \code{.ls.fitted}}{Residuals calculated calculated
by fitting separate LS regression models for each group. Level-1 LS residuals
are unconfounded by higher level residuals, but unreliable for small
within-group sample sizes.}
\item{\code{.mar.resid} and \code{.mar.fitted}}{Marginal residuals only
consider the fixed effect portion of the estimates. Equivalent to
\code{resid(object, level=0)} in \code{nlme}, not currently implemented
within the \code{lme4::resid} function. When \code{standardize = TRUE},
Cholesky marginal residuals are returned.}
\item{\strong{higher-level residuals} (random effects)}{}
\item{\code{.ranef.var_name}}{The group level random effects using the EB method of
estimating parameters. Equivalent to \code{ranef(object)} on the specified
level. EB residuals are preferred at higher levels as LS residuals are dependent
on a large sample size.}
\item{\code{.ls.var_name}}{The group level random effects using the LS method of
estimating parameters. Calculated using \code{ranef} on a \code{lmList}
object to compare the random effects of individual models to the global
model.}
}
Note that \code{standardize = "semi"} is only implemented for level-1 LS residuals.
}
\examples{
data(sleepstudy, package = "lme4")
fm.lmer <- lme4::lmer(Reaction ~ Days + (Days|Subject), sleepstudy)
fm.lme <- nlme::lme(Reaction ~ Days, random = ~Days|Subject, sleepstudy)

# level-1 and marginal residuals
fm.lmer.res1 <- hlm_resid(fm.lmer) ## raw level-1 and mar resids
fm.lmer.res1
fm.lme.std1 <- hlm_resid(fm.lme, standardize = TRUE) ## std level-1 and mar resids
fm.lme.std1

# level-2 residuals
fm.lmer.res2 <- hlm_resid(fm.lmer, level = "Subject") ## level-2 ranefs
fm.lmer.res2
fm.lme.res2 <- hlm_resid(fm.lme, level = "Subject", include.ls = FALSE) ##level-2 ranef, no LS
fm.lme.res2
}
\references{
Hilden-Minton, J. (1995) Multilevel diagnostics for mixed and hierarchical 
linear models. University of California Los Angeles.

Houseman, E. A., Ryan, L. M., & Coull, B. A. (2004) 
Cholesky Residuals for Assessing Normal Errors in a Linear 
Model With Correlated Outcomes. 
\emph{Journal of the American Statistical Association}, 99(466), 383--394.

David Robinson and Alex Hayes (2020). broom: Convert Statistical Analysis
Objects into Tidy Tibbles. R package version 0.5.6.
\url{https://CRAN.R-project.org/package=broom}
}
\seealso{
\code{\link{hlm_augment}}, \code{\link{resid}}, \code{\link{ranef}}
}
\author{
Adam Loy \email{loyad01@gmail.com}, Jack Moran, Jaylin Lowe
}
\keyword{models}
\keyword{regression}
