% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation.utility.R
\name{check.annotation.matrix.integrity}
\alias{check.annotation.matrix.integrity}
\title{Annotation matrix checker}
\usage{
check.annotation.matrix.integrity(anc, ann.spec, ann)
}
\arguments{
\item{anc}{the ancestor list.}

\item{ann.spec}{the annotation matrix of the most specific annotations (0/1): rows are genes and columns are terms.}

\item{ann}{the full annotation matrix (0/1), i.e. the matrix where the transitive closure of the annotation was performed.
Rows are examples and columns are terms.}
}
\value{
If the transitive closure of the annotations is performed correctly, \code{OK} is returned, otherwise an error message is printed on the stdout.
}
\description{
Assess the integrity of an annotation matrix where a transitive closure of annotations was performed.
}
\examples{
data(graph);
data(labels);
anc <- build.ancestors(g);
tca <- transitive.closure.annotations(L, anc);
check.annotation.matrix.integrity(anc, L, tca);
}
