% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text.R
\name{text}
\alias{text}
\title{Generate text using the Generative AI model based on a prompt}
\usage{
text(model.parameter, temperature, prompt)
}
\arguments{
\item{model.parameter}{A character vector containing the Generative AI service provider,
corresponding model, version, API key, and proxy status.}

\item{temperature}{A numeric value. A higher value results in more creative responses,
while a lower value produces more straightforward text.}

\item{prompt}{A character string representing the query for text generation.}
}
\value{
If successful, a character string generated by the Generative AI model based on
the provided query and parameters. If the API response indicates an error, the function
halts execution and provides an error message.
}
\description{
This function establishes a connection to a Generative AI model by providing essential
parameters and generates a response based on the prompt.
}
\details{
Providing accurate and valid information for each parameter is crucial
to ensure successful text generation by the Generative AI model. If any of the
provided parameters is incorrect, the function will respond with an error message based
on the information received from the API. Use the function \code{available.models()} to
see all supported Generative AI models.
}
\examples{
\dontrun{
 # Get available models
 models = available.models()

 # Connect to the model, replace API_KEY with your api key
 google.model = connect.genai("google",
                              models$google$model[1],
                              models$google$version[1],
                              "API_KEY",
                              FALSE)

 # Connect to the model, replace API_KEY with your api key
 openai.model = connect.genai("openai",
                              models$openai$model[1],
                              models$openai$version[1],
                              "API_KEY",
                              FALSE)

 # Generate text
 temperature = 0.9
 prompt = "Write a story about a magic backpack. 100 words is enough."
 google.text = text(google.model,
                    temperature,
                    prompt)
 cat(google.text)

 openai.text = text(openai.model,
                    temperature,
                    prompt)
 cat(openai.text)
}

}
