% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Candidates.R
\name{CandidatesDefault}
\alias{CandidatesDefault}
\alias{CandidatesNum}
\title{Candidates functions}
\usage{
CandidatesDefault(freq, x, secondaryZeros = FALSE, weight, ...)

CandidatesNum(secondaryZeros = FALSE, freq, num, weight, ...)
}
\arguments{
\item{freq}{Vector of output frequencies}

\item{x}{The model matrix}

\item{secondaryZeros}{When \code{TRUE}, cells with zero frequency or value are prioritized to
be published so that they are not secondary suppressed.
This is achieved by this function by having the zero frequency indices first in the retuned order.}

\item{weight}{Vector of output weights}

\item{...}{Unused parameters}

\item{num}{Data frame of output aggregates calculated from \code{numVar}. When several variables, only first is used.}
}
\value{
candidates, \code{\link{GaussSuppression}} input
}
\description{
Function for \code{\link{GaussSuppressionFromData}}
}
\details{
\code{CandidatesDefault} orders the indices decreasingly according to \code{freq} or,
when \code{weight} is non-NULL,  \code{(freq+1)*weight}. Ties are handled by prioritizing output cells
that are calculated from many input cells. In addition, zeros are handled according to parameter \code{secondaryZeros}.
When \code{freq} is negative (special hierarchy), \code{abs(freq)*weight} is used.

\code{CandidatesNum} orders the indices decreasingly according to absolute values of the numeric variable (according to  \code{abs(num[[1]])}).
In practice this is done by running \code{CandidatesDefault} with manipulated weights.
}
