% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gui_functions.R
\name{plotProgressionPath}
\alias{plotProgressionPath}
\title{plotProgressionPath}
\usage{
plotProgressionPath(cohort, hf, f)
}
\arguments{
\item{cohort}{simulated in simulateCohort()}

\item{hf}{names of the transition functions between states in the cohort.}

\item{f}{number of the path to be plotted}
}
\description{
Plots f-th most frequent progression path in the cohort
}
\examples{
hfNames <- array(rep("Exponential", 9), dim = c(3,3))
hfNames[col(hfNames)<=row(hfNames)]<-"NULL"
colnames(hfNames) <- as.list(paste("state", 1:3))
rownames(hfNames) <- as.list(paste("state", 1:3))

M <- makeM(hfNames)
par <- generateParameterMatrix(M)
par[[1,2]] <- list(rate = 1)
par[[1,3]] <- list(rate = 2)
par[[2,3]] <- list(rate = 0.5 )

cohort <- simulateCohort(
transitionFunctions = M,
parameters = par,
cohortSize = 100,
to=10)

plotProgressionPath(cohort, hfNames, 2)
}
