% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FuzzyResampling-package.R
\docType{package}
\name{FuzzyResampling-package}
\alias{FuzzyResampling}
\alias{FuzzyResampling-package}
\title{FuzzyResampling: Resampling Methods for Triangular and Trapezoidal Fuzzy Numbers}
\description{
The classical (i.e. Efron's, see Efron and Tibshirani (1994, ISBN:978-0412042317) "An Introduction to the Bootstrap") bootstrap is widely used for both the real (i.e. "crisp") and fuzzy data. The main aim of the algorithms implemented in this package is to overcome a problem with repetition of a few distinct values and to create fuzzy numbers, which are "similar" (but not the same) to values from the initial sample. To do this, different characteristics of triangular/trapezoidal numbers are kept (like the value, the ambiguity, etc., see Grzegorzewski et al. <doi:10.2991/eusflat-19.2019.68>, Grzegorzewski et al. (2020) <doi:10.2991/ijcis.d.201012.003>, Grzegorzewski et al. (2020) <doi:10.34768/amcs-2020-0022>, Romaniuk and Hryniewicz (2019) <doi:10.1007/s00500-018-3251-5>). Some additional procedures related to these resampling methods are also provided, like calculation of the Bertoluzza et al.'s distance (aka the mid/spread distance, see Bertoluzza et al. (1995) "On a new class of distances between fuzzy numbers") and estimation of the p-value of the one-sample bootstrapped test for the mean (see Lubiano et al. (2016, <doi:10.1016/j.ejor.2015.11.016>)). Additionally, there are procedures which randomly generate trapezoidal fuzzy numbers using some well-known statistical distributions.
}
\section{Resampling procedures}{

The following resampling procedures are available in the package:
\itemize{
\item \emph{classicalBootstrap} - classical approach based on Efron's method,
\item \emph{VAmethod} - resampling method which preserves the value and ambiguity,
\item \emph{EWmethod} - resampling method which preserves the expected value and width,
\item \emph{VAAmethod} - resampling method which preserves the value, left-hand and right-hand ambiguities,
\item \emph{VAFmethod} - resampling method which preserves the value, ambiguity and fuzziness,
\item \emph{dmethod} - resampling method which preserves the left end of the cores and increments,
\item \emph{wmethod} - resampling method which uses the special \emph{w density} to "smooth" the output fuzzy value.
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/mroman-ibs/FuzzyResampling}
  \item Report bugs at \url{https://github.com/mroman-ibs/FuzzyResampling/issues}
}

}
\author{
\strong{Maintainer}: Maciej Romaniuk \email{mroman@ibspan.waw.pl}

Authors:
\itemize{
  \item Przemyslaw Grzegorzewski \email{przemyslaw.grzegorzewski@ibspan.waw.pl}
  \item Olgierd Hryniewicz \email{hryniewi@ibspan.waw.pl}
}

}
\keyword{internal}
