% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{fuzzyr.accuracy}
\alias{fuzzyr.accuracy}
\title{Fuzzy Accuracy}
\usage{
fuzzyr.accuracy(f, y, f.ref = 0, scale.mase = NULL)
}
\arguments{
\item{f}{A vector of forecasting values produced by a model to be evaluated.}

\item{y}{A vector of observed values.}

\item{f.ref}{A vector of forecasting values produced by a benchmark method to be compared.}

\item{scale.mase}{A single value which is the scaling factor of the measure MASE.}
}
\value{
A vector of results by each measure.
}
\description{
This function is to provide performance indicators by using eight different accuracy measures including a new measure UMBRAE.
}
\examples{
f <- rnorm(10)
y <- rnorm(10)
fuzzyr.accuracy(f, y)
}
\references{
[1] C. Chen, J. Twycross, and J. M. Garibaldi, “A new accuracy measure based on bounded relative error for time series forecasting,” PLOS ONE, vol. 12, no. 3, pp. 1–23, 2017. \cr
\url{http://dx.doi.org/10.1371/journal.pone.0174202}
}
\author{
Chao Chen
}
