% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FuzzyOperation.R
\name{km.da}
\alias{km.da}
\title{km.da}
\usage{
km.da(wl, wr, f, maximum = F, w.which = F, sorted = F, k.which = F)
}
\arguments{
\item{wl}{A vector of lower membership grades.}

\item{wr}{A vector of upper membership grades.}

\item{f}{A vector of the primary values in the discrete universe of discourse X.}

\item{maximum}{T, to calculate the maximum centroid; F, to calulate the minimum centroid.}

\item{w.which}{T, to show which membership grade to be used to calculate maximum/minimum centroid for each primary value.}

\item{sorted}{T, to indicate that the primary values have already been put in ascending order.}

\item{k.which}{T, to show the index of the switch point selected by the algorithm.}
}
\value{
w.which=T, a two-column matrix indicating which membership grades to be used; 
w.which=F and k.which=T, a vector of the centroid and the switch point; 
w.which=F and k.which=F, a single value of the centroid.
}
\description{
A Direct Approach for Determining the Switch Points in the Karnik-Mendel Algorithm.
}
\examples{
wr <- runif(100, 0, 1)
wl <- wr * runif(100, 0, 1)
f <- abs(runif(100, 0, 1))
f <- sort(f)
km.da(wl, wr, f)
}
\author{
Chao Chen
}
\references{
A Direct Approach for Determining the Switch Points in the Karnik-Mendel Algorithm.
}

