% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FuzzyInferenceSystem.R
\name{anfis.plotmf}
\alias{anfis.plotmf}
\title{Plot membership functions for an ANFIS object}
\usage{
anfis.plotmf(anfis, varType, varIndex, xx = NULL, timelimit = 0,
  xlab = NULL, ylab = NULL, main = NULL)
}
\arguments{
\item{anfis}{Requires an existing anfis as an argument.}

\item{varType}{Can be either 'input' or 'output', representing the type of variable.}

\item{varIndex}{A numerical integer, representing the index of the input or output variable whose membership functions shall be plotted (base 1).}

\item{xx}{primary inputs for extra lines}

\item{timelimit}{for perturbation}

\item{xlab}{X axis label using font, size and color}

\item{ylab}{Y axis label, same font attributes as xlab}

\item{main}{The main title (on top)}
}
\value{
A two dimensional graph displaying all the membership functions of a given variable.
}
\description{
Plots a 2D graph of all membership functions from the specified variable which must be part of an anfis object.
}
\examples{
fis <- anfis.tipper()
anfis <- anfis.builder(fis)
data.num <- 5
input.num <- length(fis$input)
input.stack <- matrix(rnorm(data.num*input.num), ncol=input.num)
y <- matrix(rnorm(data.num))
data.trn <- cbind(input.stack, y)
anfis.eval(anfis, input.stack)
anfis.final <- anfis.optimise(anfis, data.trn, epoch.total=500,
                                 stepsize=0.01, rate.inc=1.1, rate.dec=0.9)
anfis.plotmf(anfis, 'input', 1)
anfis.plotmf(anfis.final, 'input', 1)
}

